package hope.common.spring.api;

public interface Constants {
  String HOPE_API_PREFIX = "hope.open.api";

  /**
   * @see HopeApiProperties#enable
   */
  String API_ENABLE = HOPE_API_PREFIX + ".enable";

  String API_META_ENABLE = HOPE_API_PREFIX + ".showMeta";

  String API_SPA_ENABLE = HOPE_API_PREFIX + ".spa";

  String RESOURCES_PATH = "swagger/";

  String DEFAULT_API_DOCS_URL = "/v3/api-docs";

  /**
   * same as:
   *
   * @see HopeApiProperties#path
   * @see #API_DOCS_URL_YAML
   */
  String API_DOCS_URL =
      "${hope.open.api.path:#{T(hope.common.spring.api.Constants).DEFAULT_API_DOCS_URL}}";

  /**
   * @see HopeApiProperties#path
   * @see #API_DOCS_URL
   */
  String API_DOCS_URL_YAML = API_DOCS_URL + ".yaml";

  String APPLICATION_OPENAPI_YAML = "application/vnd.oai.openapi";
}
