package hope.common.spring.api.spa;

@FunctionalInterface
public interface SpaPathChecker {

  SpaPathChecker DEFAULT =
      path ->
          !path.startsWith("/api")
              && !path.startsWith("/management")
              && !path.startsWith("/v3/api-docs")
              && !path.startsWith("/hope/meta")
              && !path.startsWith("/h2-console")
              && !path.contains(".")
              && path.matches("/(.*)");

  boolean passToSpa(final String url);
}
