package hope.common.spring.api.spa.wbmvc;

import static hope.common.spring.api.Constants.API_SPA_ENABLE;

import hope.common.spring.api.spa.SpaPathChecker;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;

@Lazy(false)
@Configuration(proxyBeanMethods = false)
@ConditionalOnProperty(name = API_SPA_ENABLE) // matchIfMissing = false
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.SERVLET)
public class SpaMvcConfiguration {

  protected final SpaPathChecker checker;

  public SpaMvcConfiguration(final ObjectProvider<SpaPathChecker> checkerObjectProvider) {
    this.checker = checkerObjectProvider.getIfAvailable(() -> SpaPathChecker.DEFAULT);
  }

  @ConditionalOnProperty(name = API_SPA_ENABLE)
  @Bean
  public SpaWebFilter spaWebFilter() {
    return new SpaWebFilter(checker);
  }
}
