package hope.common.spring.api.spa.wbmvc;

import hope.common.spring.api.spa.SpaPathChecker;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import org.springframework.web.filter.OncePerRequestFilter;

public class SpaWebFilter extends OncePerRequestFilter {

  protected final SpaPathChecker checker;

  public SpaWebFilter(SpaPathChecker checker) {
    this.checker = checker;
  }

  /**
   * Forwards any unmapped paths (except those containing a period) to the client {@code
   * index.html}.
   */
  @Override
  protected void doFilterInternal(
      HttpServletRequest request, HttpServletResponse response, FilterChain filterChain)
      throws ServletException, IOException {
    // Request URI includes the contextPath if any, removed it.
    String path = request.getRequestURI().substring(request.getContextPath().length());
    if (checker.passToSpa(path)) {
      request.getRequestDispatcher("/index.html").forward(request, response);
      return;
    }

    filterChain.doFilter(request, response);
  }
}
