package hope.common.spring.api.webflux;

import static hope.common.spring.api.Constants.API_ENABLE;

import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.annotation.Lazy;

@Lazy(false)
@Configuration(proxyBeanMethods = false)
@ConditionalOnWebApplication(type = ConditionalOnWebApplication.Type.REACTIVE)
@ConditionalOnProperty(name = API_ENABLE, matchIfMissing = true)
@Import(ApiWebFluxResource.class)
public class WebFluxConfiguration {}
