package it.hope.plugin.wire;

import org.gradle.api.Project;
import org.gradle.api.provider.Property;

import javax.inject.Inject;

public class HopeServerExtension {
  /** The server URL which accept the metadata upload and analyst */
  protected final Property<String> url;

  /**
   * the App key setup at the server side
   *
   * @apiNote this is the key for the server to identify the client, do not share in the GIT, better
   *     pass through env
   */
  protected final Property<String> appKey;

  /**
   * the App key secret at the server side
   *
   * @apiNote this is the secret for the server to auth the client, do not share in the GIT, better
   *     pass through env
   */
  protected final Property<String> appSecret;

  /** Any version specific, it not set then the latest one will be used */
  protected final Property<String> version;

  /** The name of the project, if not set then the project name will be used */
  protected final Property<String> name;

  @Inject
  public HopeServerExtension(Project project) {
    url = project.getObjects().property(String.class);
    appKey = project.getObjects().property(String.class);
    appSecret = project.getObjects().property(String.class);
    version = project.getObjects().property(String.class);
    name = project.getObjects().property(String.class);
  }

  public Property<String> getUrl() {
    return url;
  }

  public Property<String> getAppKey() {
    return appKey;
  }

  public Property<String> getAppSecret() {
    return appSecret;
  }

  public Property<String> getVersion() {
    return version;
  }

  public Property<String> getName() {
    return name;
  }
}
