/*
 * Decompiled with CFR 0.152.
 */
package it.hope.plugin.wire;

import it.hope.plugin.wire.HopeServerExtension;
import it.hope.plugin.wire.HopeWireExtension;
import it.hope.plugin.wire.JarTypeFileSpec;
import it.hope.plugin.wire.tasks.WireCleanTask;
import it.hope.plugin.wire.tasks.WireGeneratorTask;
import it.hope.plugin.wire.tasks.WirePublishTask;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.plugins.JavaPluginExtension;
import org.gradle.api.plugins.ObjectConfigurationAction;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.bundling.Jar;
import org.gradle.api.tasks.compile.JavaCompile;

public class HopeWirePlugin
implements Plugin<Project> {
    protected static final String WIRE_GRADLE_SCRIPT = "/wire-shared.gradle";
    static final Set<String> dependTasks = new HashSet<String>(){
        {
            this.add("classes");
            this.add("compileJava");
            this.add("compileTestJava");
            this.add("testClasses");
        }
    };
    protected HopeWireExtension hopeWireExtension;
    protected HopeServerExtension hopeServerExtension;

    public void apply(Project project) {
        this.hopeWireExtension = (HopeWireExtension)project.getExtensions().create("hopeWire", HopeWireExtension.class, new Object[0]);
        this.hopeServerExtension = (HopeServerExtension)project.getExtensions().create("hopeServer", HopeServerExtension.class, new Object[0]);
        Action _action = self -> this.afterEvaluate((Project)self);
        project.afterEvaluate(_action);
    }

    private void afterEvaluate(Project project) {
        Action<ObjectConfigurationAction> configurationAction = new Action<ObjectConfigurationAction>(){

            public void execute(ObjectConfigurationAction objectConfigurationAction) {
                objectConfigurationAction.from((Object)this.getClass().getResource(HopeWirePlugin.WIRE_GRADLE_SCRIPT));
            }
        };
        Action javaApplied = arg_0 -> HopeWirePlugin.lambda$afterEvaluate$1(project, (Action)configurationAction, arg_0);
        project.getPluginManager().withPlugin("java", javaApplied);
        if (((Boolean)this.hopeWireExtension.getDisable().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
            project.getLogger().warn("WIRE_PLUGIN_DISABLE_NO_MORE_ACTION");
            return;
        }
        this.buildWireStandAloneTask(project);
        this.injectJarTask(project);
        this.configureUtf8Encoding(project);
    }

    private void injectJarTask(Project project) {
        boolean keepProto = (Boolean)this.hopeWireExtension.getKeepProto().getOrElse((Object)Boolean.FALSE);
        project.getLogger().warn("PROTOC_CLASS_WILL_{} {}", (Object)(keepProto ? "INCLUDED" : "EXCLUDED"), (Object)project.getName());
        if (!keepProto) {
            project.getTasks().withType(Jar.class, jar -> {
                Spec spec = element -> {
                    if (this.qualifyName(element.getName()) && element.getPath().contains("/proto")) {
                        project.getLogger().debug("EXCLUDE_PROTO_PATH {}", (Object)element.getPath());
                        return true;
                    }
                    return false;
                };
                jar.exclude(spec);
            });
        }
    }

    private void buildWireStandAloneTask(Project project) {
        Configuration config = ((Configuration)project.getConfigurations().create("wireStandalone")).setVisible(false);
        config.defaultDependencies(dependencies -> {
            String wireVersion = "com.apihug:it-wire:" + (String)this.hopeWireExtension.getPluginMainVersion().getOrElse((Object)"0.9.9-RELEASE");
            project.getLogger().warn("it-wire runtime: {}", (Object)wireVersion);
            if (((Boolean)this.hopeWireExtension.getLocal().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
                project.getLogger().warn("[com.apihug:it-wire] applied no need to add again");
            } else {
                project.getLogger().warn("add dependency of the [com.apihug:it-wire]: {}", (Object)wireVersion);
                dependencies.add((Object)project.getDependencies().create((Object)wireVersion));
            }
            dependencies.add((Object)project.getDependencies().create((Object)"ch.qos.logback:logback-classic:1.4.5"));
        });
        Callable<FileCollection> classpath = () -> ((SourceSet)this.javaPluginExtension(project).getSourceSets().findByName("main")).getRuntimeClasspath().filter((Spec)new JarTypeFileSpec());
        WireGeneratorTask task = (WireGeneratorTask)project.getTasks().create("wire", WireGeneratorTask.class);
        task.setGroup("build");
        task.setBuildClasspath((Iterable<File>)config);
        task.setClasspath(classpath);
        task.setExtension(this.hopeWireExtension);
        for (String dependTask : dependTasks) {
            try {
                if (project.getTasks().findByPath(dependTask) == null) continue;
                task.dependsOn(new Object[]{dependTask});
            }
            catch (Exception e) {
                project.getLogger().warn("Exception in task dependencies: " + e.getMessage(), (Throwable)e);
            }
        }
        Task build = project.getTasks().findByPath("build");
        if (build != null) {
            build.dependsOn(new Object[]{task});
        }
        WireCleanTask cleanTask = (WireCleanTask)project.getTasks().create("wireClean", WireCleanTask.class);
        cleanTask.setGroup("build");
        WirePublishTask publishTask = (WirePublishTask)project.getTasks().create("wirePublish", WirePublishTask.class);
        publishTask.setExtension(this.hopeServerExtension);
        publishTask.setGroup("publishing");
    }

    private boolean qualifyName(String name) {
        if (name != null && !name.isEmpty()) {
            return name.endsWith(".java") || name.endsWith(".class");
        }
        return false;
    }

    private JavaPluginExtension javaPluginExtension(Project project) {
        return (JavaPluginExtension)project.getExtensions().getByType(JavaPluginExtension.class);
    }

    private void configureUtf8Encoding(Project evaluatedProject) {
        evaluatedProject.getTasks().withType(JavaCompile.class).configureEach(this::configureUtf8Encoding);
    }

    private void configureUtf8Encoding(JavaCompile compile) {
        if (compile.getOptions().getEncoding() == null) {
            compile.getOptions().setEncoding("UTF-8");
        }
    }

    private static /* synthetic */ void lambda$afterEvaluate$1(Project project, Action configurationAction, AppliedPlugin appliedPlugin) {
        project.apply(configurationAction);
    }
}

