/*
 * Decompiled with CFR 0.152.
 */
package it.hope.plugin.wire.tasks;

import it.hope.plugin.wire.HopeWireExtension;
import it.hope.plugin.wire.json.JSONObject;
import java.io.File;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Callable;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.slf4j.Logger;

@DisableCachingByDefault(because="Hope wire main task will do proto collect and generate")
public class WireGeneratorTask
extends DefaultTask {
    private static final Logger logger = Logging.getLogger(WireGeneratorTask.class);
    private Iterable<File> buildClasspath;
    private Callable<FileCollection> classpath;
    @Internal
    private String mainClassName = "hope.proto.wire.Main";
    private HopeWireExtension extension;

    protected static Method pick(String mainClassName, ClassLoader classLoader) throws ClassNotFoundException, NoSuchMethodException {
        Class<?> clz = classLoader.loadClass(mainClassName);
        Method mainMethod = clz.getDeclaredMethod("main", String[].class);
        mainMethod.setAccessible(true);
        return mainMethod;
    }

    public static void verifyWireMeta(Project project) {
        boolean hasMeta;
        File meta = Paths.get(project.getProjectDir().getAbsolutePath(), "src", "main", "resources", "hope-wire.json").toFile();
        boolean bl = hasMeta = meta.exists() && meta.canRead();
        if (!hasMeta) {
            throw new IllegalStateException("Since [0.1.2-RELEASE] you need place project meta file under the " + meta.getAbsolutePath());
        }
    }

    public static void writeConfig(Project project, Path path, HopeWireExtension extension) throws Exception {
        JSONObject wireConfiguration = new JSONObject();
        JSONObject artifact = new JSONObject();
        artifact.put("groupId", project.getGroup().toString());
        artifact.put("artifactId", project.getName());
        artifact.put("version", project.getVersion().toString());
        wireConfiguration.put("artifact", artifact);
        wireConfiguration.put("name", project.getName());
        wireConfiguration.put("description", project.getDescription());
        JSONObject builder = new JSONObject();
        builder.put("dir", project.getProjectDir().getAbsolutePath());
        builder.put("buildDir", project.getBuildDir().getAbsolutePath());
        builder.put("pluginVersion", extension.getPluginMainVersion().getOrElse((Object)"NA"));
        if (project.getParent() != null) {
            builder.put("parent", WireGeneratorTask.pickParent(project.getParent(), null));
        }
        wireConfiguration.put("builder", builder);
        JSONObject wire = new JSONObject();
        wire.put("debug", (Boolean)extension.getDebug().getOrElse((Object)Boolean.FALSE));
        wire.put("restrict", (Boolean)extension.getRestrict().getOrElse((Object)Boolean.TRUE));
        wire.put("protoGenDir", "protoGen");
        wire.put("wireGenDir", "wireGen");
        wire.put("keepProto", (Boolean)extension.getKeepProto().getOrElse((Object)Boolean.TRUE));
        String wirePath = project.getProjectDir().toPath().resolve("src").resolve("main").resolve("wire").toAbsolutePath().toString();
        wire.put("wirePath", wirePath);
        wireConfiguration.put("wire", wire);
        String config = wireConfiguration.toString(2);
        Files.write(path, config.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        if (((Boolean)extension.getVerbose().getOrElse((Object)false)).booleanValue()) {
            logger.debug("\n\nConfig @ [{}] \n{}\n", (Object)path.toAbsolutePath(), (Object)config);
        }
    }

    public static String safeGetProperty(String key) {
        try {
            return System.getProperty(key);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    protected static String pickParent(Project project, String prefix) {
        if (project != null && project.getParent() != null) {
            Object newPrefix = prefix == null || prefix.isBlank() ? project.getParent().getName() : project.getParent().getName() + ":" + prefix;
            return WireGeneratorTask.pickParent(project.getParent().getParent(), (String)newPrefix);
        }
        return prefix;
    }

    public WireGeneratorTask setClasspath(Callable<FileCollection> classpath) {
        this.classpath = classpath;
        return this;
    }

    @Classpath
    @Optional
    public Iterable<File> getBuildClasspath() {
        return this.buildClasspath;
    }

    public void setBuildClasspath(Iterable<File> buildClasspath) {
        this.buildClasspath = buildClasspath;
    }

    public String getMainClassName() {
        return this.mainClassName;
    }

    public WireGeneratorTask setMainClassName(String mainClassName) {
        this.mainClassName = mainClassName;
        return this;
    }

    @TaskAction
    public void doWire() throws GradleException {
        URL[] urls;
        WireGeneratorTask.verifyWireMeta(this.getProject());
        boolean verbose = (Boolean)this.extension.getVerbose().getOrElse((Object)false);
        logger.info("Resolving OpenAPI specification..");
        Stream<Object> classpathStream = Stream.empty();
        if (this.classpath != null) {
            try {
                classpathStream = StreamSupport.stream(this.classpath.call().spliterator(), false).map(f -> {
                    try {
                        return f.toURI().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new GradleException(String.format("Could not create classpath for annotations task %s.", this.getName()), (Throwable)e);
                    }
                });
            }
            catch (Exception e) {
                logger.error("FAIL_GET_CLASS_PATH_RUN_TIME {}", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
        Stream<Object> buildClasspathStream = Stream.empty();
        if (this.getBuildClasspath() != null) {
            buildClasspathStream = StreamSupport.stream(this.getBuildClasspath().spliterator(), false).map(f -> {
                try {
                    return f.toURI().toURL();
                }
                catch (MalformedURLException e) {
                    throw new GradleException(String.format("Could not create classpath for annotations task %s.", this.getName()), (Throwable)e);
                }
            });
        }
        for (URL url : urls = (URL[])Stream.concat(classpathStream, buildClasspathStream).distinct().toArray(URL[]::new)) {
            if (!verbose) continue;
            logger.debug("WIRE_RUN_TIME_CLASS_PATH: {}", (Object)url);
        }
        URLClassLoader classLoader = new URLClassLoader(urls);
        try {
            Method mainMethod = WireGeneratorTask.pick(this.mainClassName, classLoader);
            Path path = Files.createTempFile("it-plugin-wire-", ".json", new FileAttribute[0]);
            WireGeneratorTask.writeConfig(this.getProject(), path, this.extension);
            if (((Boolean)this.extension.getSmock().getOrElse((Object)Boolean.FALSE)).booleanValue()) {
                logger.warn("SMOCK_VERIFY_SKIP_FURTHER_ACTION");
                return;
            }
            String forceOverwrite = WireGeneratorTask.safeGetProperty("forceOverwrite");
            String[] converter = new String[]{"-Dinput.args=" + String.valueOf(path.toAbsolutePath()), "-DbuildVerbose=" + String.valueOf(this.extension.getVerbose().getOrElse((Object)false)), "-DgeneratedVersion=" + String.valueOf(this.extension.getGeneratedVersion().getOrElse((Object)false)), "-DgeneratedTime=" + String.valueOf(this.extension.getGeneratedTime().getOrElse((Object)false)), "-DignoreWireSource=" + String.valueOf(this.extension.getIgnoreWireSource().getOrElse((Object)false)), "-Dkola=" + String.valueOf(this.extension.getKola().getOrElse((Object)false)), "-DforceOverwrite=" + "true".equals(forceOverwrite)};
            mainMethod.invoke(null, new Object[]{converter});
        }
        catch (Throwable throwable) {
            logger.error("fail wire generator", throwable);
            throw new RuntimeException(throwable);
        }
    }

    public void setExtension(HopeWireExtension extension) {
        this.extension = extension;
    }
}

