/*
 * Decompiled with CFR 0.152.
 */
package it.hope.plugin.wire.tasks;

import it.hope.plugin.wire.HopeServerExtension;
import it.hope.plugin.wire.ZipUtils;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import java.util.stream.Collectors;
import org.gradle.api.DefaultTask;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.TaskAction;
import org.gradle.work.DisableCachingByDefault;
import org.slf4j.Logger;

@DisableCachingByDefault(because="Hope wire publish task will publish the wire proto to the server")
public class WirePublishTask
extends DefaultTask {
    private static Logger logger = Logging.getLogger(WirePublishTask.class);
    protected HopeServerExtension extension;

    @TaskAction
    public void publish() {
        String name;
        Path path;
        logger.warn("TRY_PUBLISH_WIRE_TO_SERVICE: ZIP->Publish need proxy + appKey + appSecret");
        String url = (String)this.extension.getUrl().getOrElse(null);
        String appKey = (String)this.extension.getAppKey().getOrElse(null);
        String appSecret = (String)this.extension.getAppSecret().getOrElse(null);
        String baseDir = this.getProject().getProjectDir().getAbsolutePath();
        File resourcesDir = Path.of(baseDir, "src", "main", "resources").toFile();
        logger.warn("PREPARE_RESOURCE_FROM_LOCATION: {}", (Object)resourcesDir);
        if (!resourcesDir.exists()) {
            logger.warn("NO_RESOURCE_FOUND: {}", (Object)resourcesDir);
            return;
        }
        if (!resourcesDir.isDirectory()) {
            logger.warn("RESOURCE_IS_NOT_DIR: {}", (Object)resourcesDir);
            return;
        }
        String projectName = this.getProject().getName();
        try {
            path = ZipUtils.zip(resourcesDir, "metaFile");
            logger.warn("ZIP_RESOURCE_AT {}", (Object)path.toAbsolutePath());
        }
        catch (IOException e) {
            throw new RuntimeException("FAIL_ZIP_RESOURCE " + String.valueOf(resourcesDir), e);
        }
        HashMap<String, String> requestParams = new HashMap<String, String>();
        String version = (String)this.extension.getVersion().getOrElse(null);
        if (version != null && !version.isBlank()) {
            requestParams.put("version", version);
        }
        if ((name = (String)this.extension.getName().getOrElse(null)) != null && !name.isBlank()) {
            requestParams.put("name", name);
        } else {
            requestParams.put("name", projectName);
        }
        requestParams.put("appKey", appKey);
        requestParams.put("appSecret", appSecret);
        String encodedURL = requestParams.keySet().stream().map(key -> key + "=" + this.encodeValue((String)requestParams.get(key))).collect(Collectors.joining("&", url, ""));
        logger.warn("TRY_PUBLISH_WIRE_TO_SERVICE: {}", (Object)encodedURL);
        this.upload(path, encodedURL);
    }

    private String encodeValue(String value) {
        try {
            return URLEncoder.encode(value, StandardCharsets.UTF_8.toString());
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private void upload(Path path, String url) {
        HttpRequest.Builder hb;
        HttpClient client = HttpClient.newHttpClient();
        try {
            hb = HttpRequest.newBuilder(URI.create(url)).timeout(Duration.ofMinutes(3L));
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        try {
            this.multipleForm(hb, path);
            HttpResponse<String> responseOfString = client.send(hb.build(), HttpResponse.BodyHandlers.ofString());
            if (200 != responseOfString.statusCode()) {
                throw new RuntimeException("FAIL_UPLOAD " + String.valueOf(path) + " " + responseOfString.statusCode());
            }
            logger.debug("UPLOAD_SUCCESS: {} WITH_RESPONSE {}", (Object)path, (Object)responseOfString.body());
        }
        catch (IOException e) {
            throw new RuntimeException("IO_EXCEPTION " + String.valueOf(path), e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException("INTERRUPT " + String.valueOf(path), e);
        }
    }

    public WirePublishTask setExtension(HopeServerExtension extension) {
        this.extension = extension;
        return this;
    }

    private HttpRequest.Builder multipleForm(HttpRequest.Builder builder, Path path) throws IOException {
        String boundary = new BigInteger(35, new Random()).toString();
        byte[] separator = ("--" + boundary + "\r\nContent-Disposition: form-data; name=").getBytes(StandardCharsets.UTF_8);
        ArrayList<byte[]> byteArrays = new ArrayList<byte[]>();
        byteArrays.add(separator);
        String miniType = Files.probeContentType(path);
        byteArrays.add(("\"metaFile\"; filename=\"metaFile\"\r\nContent-Type: " + miniType + "\r\n\r\n").getBytes(StandardCharsets.UTF_8));
        byteArrays.add(Files.readAllBytes(path));
        byteArrays.add("\r\n".getBytes(StandardCharsets.UTF_8));
        byteArrays.add("--$boundary--".getBytes(StandardCharsets.UTF_8));
        builder.header("Content-Type", "multipart/form-data;boundary=" + boundary).POST(HttpRequest.BodyPublishers.ofByteArrays(byteArrays));
        return builder;
    }
}

