package it.hope.plugin.wire;

import it.hope.plugin.wire.tasks.WirePublishTask;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.gradle.api.logging.Logging;
import org.slf4j.Logger;

public class ZipUtils {
  private static Logger logger = Logging.getLogger(WirePublishTask.class);

  public static Path zip(final File dir, final String name) throws IOException {

    final Path path = Files.createTempFile(name, ".zip");

    final FileOutputStream fos = new FileOutputStream(path.toFile());
    final ZipOutputStream zipOut = new ZipOutputStream(fos);

    zipFile(dir, dir.getName(), zipOut);
    zipOut.close();
    fos.close();

    return path;
  }

  private static void zipFile(File fileToZip, String fileName, ZipOutputStream zipOut)
      throws IOException {
    if (fileToZip.isHidden() || fileToZip.getName().startsWith(".")) {
      logger.debug("Skip hidden file {}", fileToZip);
      return;
    }
    if (fileToZip.isDirectory()) {
      if (fileName.endsWith("/")) {
        zipOut.putNextEntry(new ZipEntry(fileName));
        zipOut.closeEntry();
      } else {
        zipOut.putNextEntry(new ZipEntry(fileName + "/"));
        zipOut.closeEntry();
      }
      File[] children = fileToZip.listFiles();
      for (File childFile : children) {
        zipFile(childFile, fileName + "/" + childFile.getName(), zipOut);
      }
      return;
    }
    FileInputStream fis = new FileInputStream(fileToZip);
    ZipEntry zipEntry = new ZipEntry(fileName);
    zipOut.putNextEntry(zipEntry);
    byte[] bytes = new byte[1024];
    int length;
    while ((length = fis.read(bytes)) >= 0) {
      zipOut.write(bytes, 0, length);
    }
    fis.close();
  }
}
