/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.voyager.client.models;

import com.appscode.voyager.client.models.V1beta1CertificateStorage;
import com.appscode.voyager.client.models.V1beta1ChallengeProvider;
import com.appscode.voyager.client.models.V1beta1LocalTypedReference;
import com.google.gson.annotations.SerializedName;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V1beta1CertificateSpec {
    @SerializedName(value="acmeStagingURL")
    private String acmeStagingURL = null;
    @SerializedName(value="acmeUserSecretName")
    private String acmeUserSecretName = null;
    @SerializedName(value="challengeProvider")
    private V1beta1ChallengeProvider challengeProvider = null;
    @SerializedName(value="domains")
    private List<String> domains = null;
    @SerializedName(value="email")
    private String email = null;
    @SerializedName(value="httpProviderIngressReference")
    private V1beta1LocalTypedReference httpProviderIngressReference = null;
    @SerializedName(value="paused")
    private Boolean paused = null;
    @SerializedName(value="provider")
    private String provider = null;
    @SerializedName(value="providerCredentialSecretName")
    private String providerCredentialSecretName = null;
    @SerializedName(value="storage")
    private V1beta1CertificateStorage storage = null;

    public V1beta1CertificateSpec acmeStagingURL(String acmeStagingURL) {
        this.acmeStagingURL = acmeStagingURL;
        return this;
    }

    @ApiModelProperty(value="ACME server that will be used to obtain this certificate. Deprecated")
    public String getAcmeStagingURL() {
        return this.acmeStagingURL;
    }

    public void setAcmeStagingURL(String acmeStagingURL) {
        this.acmeStagingURL = acmeStagingURL;
    }

    public V1beta1CertificateSpec acmeUserSecretName(String acmeUserSecretName) {
        this.acmeUserSecretName = acmeUserSecretName;
        return this;
    }

    @ApiModelProperty(required=true, value="Secret contains ACMEUser information. Secret must contain a key `email` If empty tries to find an Secret via domains if not found create an ACMEUser and stores as a secret. Secrets key to be expected:  ACME_EMAIL -> required, if not provided it will through error.  ACME_SERVER_URL -> custom server url to generate certificates, default is lets encrypt.  ACME_USER_DATA -> user data, if not found one will be created for the provided email,    and stored in the key.")
    public String getAcmeUserSecretName() {
        return this.acmeUserSecretName;
    }

    public void setAcmeUserSecretName(String acmeUserSecretName) {
        this.acmeUserSecretName = acmeUserSecretName;
    }

    public V1beta1CertificateSpec challengeProvider(V1beta1ChallengeProvider challengeProvider) {
        this.challengeProvider = challengeProvider;
        return this;
    }

    @ApiModelProperty(required=true, value="ChallengeProvider details to verify domains")
    public V1beta1ChallengeProvider getChallengeProvider() {
        return this.challengeProvider;
    }

    public void setChallengeProvider(V1beta1ChallengeProvider challengeProvider) {
        this.challengeProvider = challengeProvider;
    }

    public V1beta1CertificateSpec domains(List<String> domains) {
        this.domains = domains;
        return this;
    }

    public V1beta1CertificateSpec addDomainsItem(String domainsItem) {
        if (this.domains == null) {
            this.domains = new ArrayList<String>();
        }
        this.domains.add(domainsItem);
        return this;
    }

    @ApiModelProperty(value="Tries to obtain a single certificate using all domains passed into Domains. The first domain in domains is used for the CommonName field of the certificate, all other domains are added using the Subject Alternate Names extension.")
    public List<String> getDomains() {
        return this.domains;
    }

    public void setDomains(List<String> domains) {
        this.domains = domains;
    }

    public V1beta1CertificateSpec email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="Deprecated")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public V1beta1CertificateSpec httpProviderIngressReference(V1beta1LocalTypedReference httpProviderIngressReference) {
        this.httpProviderIngressReference = httpProviderIngressReference;
        return this;
    }

    @ApiModelProperty(value="This is the ingress Reference that will be used if provider is http Deprecated")
    public V1beta1LocalTypedReference getHttpProviderIngressReference() {
        return this.httpProviderIngressReference;
    }

    public void setHttpProviderIngressReference(V1beta1LocalTypedReference httpProviderIngressReference) {
        this.httpProviderIngressReference = httpProviderIngressReference;
    }

    public V1beta1CertificateSpec paused(Boolean paused) {
        this.paused = paused;
        return this;
    }

    @ApiModelProperty(value="Indicates that the certificate is paused.")
    public Boolean isPaused() {
        return this.paused;
    }

    public void setPaused(Boolean paused) {
        this.paused = paused;
    }

    public V1beta1CertificateSpec provider(String provider) {
        this.provider = provider;
        return this;
    }

    @ApiModelProperty(value="Following fields are deprecated and will removed in future version. https://github.com/appscode/voyager/pull/506 Deprecated. DNS Provider.")
    public String getProvider() {
        return this.provider;
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public V1beta1CertificateSpec providerCredentialSecretName(String providerCredentialSecretName) {
        this.providerCredentialSecretName = providerCredentialSecretName;
        return this;
    }

    @ApiModelProperty(value="ProviderCredentialSecretName is used to create the acme client, that will do needed processing in DNS. Deprecated")
    public String getProviderCredentialSecretName() {
        return this.providerCredentialSecretName;
    }

    public void setProviderCredentialSecretName(String providerCredentialSecretName) {
        this.providerCredentialSecretName = providerCredentialSecretName;
    }

    public V1beta1CertificateSpec storage(V1beta1CertificateStorage storage) {
        this.storage = storage;
        return this;
    }

    @ApiModelProperty(value="Storage backend to store the certificates currently, kubernetes secret and vault.")
    public V1beta1CertificateStorage getStorage() {
        return this.storage;
    }

    public void setStorage(V1beta1CertificateStorage storage) {
        this.storage = storage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1CertificateSpec v1beta1CertificateSpec = (V1beta1CertificateSpec)o;
        return Objects.equals(this.acmeStagingURL, v1beta1CertificateSpec.acmeStagingURL) && Objects.equals(this.acmeUserSecretName, v1beta1CertificateSpec.acmeUserSecretName) && Objects.equals(this.challengeProvider, v1beta1CertificateSpec.challengeProvider) && Objects.equals(this.domains, v1beta1CertificateSpec.domains) && Objects.equals(this.email, v1beta1CertificateSpec.email) && Objects.equals(this.httpProviderIngressReference, v1beta1CertificateSpec.httpProviderIngressReference) && Objects.equals(this.paused, v1beta1CertificateSpec.paused) && Objects.equals(this.provider, v1beta1CertificateSpec.provider) && Objects.equals(this.providerCredentialSecretName, v1beta1CertificateSpec.providerCredentialSecretName) && Objects.equals(this.storage, v1beta1CertificateSpec.storage);
    }

    public int hashCode() {
        return Objects.hash(this.acmeStagingURL, this.acmeUserSecretName, this.challengeProvider, this.domains, this.email, this.httpProviderIngressReference, this.paused, this.provider, this.providerCredentialSecretName, this.storage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1CertificateSpec {\n");
        sb.append("    acmeStagingURL: ").append(this.toIndentedString(this.acmeStagingURL)).append("\n");
        sb.append("    acmeUserSecretName: ").append(this.toIndentedString(this.acmeUserSecretName)).append("\n");
        sb.append("    challengeProvider: ").append(this.toIndentedString(this.challengeProvider)).append("\n");
        sb.append("    domains: ").append(this.toIndentedString(this.domains)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    httpProviderIngressReference: ").append(this.toIndentedString(this.httpProviderIngressReference)).append("\n");
        sb.append("    paused: ").append(this.toIndentedString(this.paused)).append("\n");
        sb.append("    provider: ").append(this.toIndentedString(this.provider)).append("\n");
        sb.append("    providerCredentialSecretName: ").append(this.toIndentedString(this.providerCredentialSecretName)).append("\n");
        sb.append("    storage: ").append(this.toIndentedString(this.storage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

