/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.voyager.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.IntOrString;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class V1beta1HTTPIngressBackend {
    @SerializedName(value="backendRules")
    private List<String> backendRules = null;
    @SerializedName(value="headerRules")
    private List<String> headerRules = null;
    @SerializedName(value="hostNames")
    private List<String> hostNames = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="rewriteRules")
    private List<String> rewriteRules = null;
    @SerializedName(value="serviceName")
    private String serviceName = null;
    @SerializedName(value="servicePort")
    private IntOrString servicePort = null;

    public V1beta1HTTPIngressBackend backendRules(List<String> backendRules) {
        this.backendRules = backendRules;
        return this;
    }

    public V1beta1HTTPIngressBackend addBackendRulesItem(String backendRulesItem) {
        if (this.backendRules == null) {
            this.backendRules = new ArrayList<String>();
        }
        this.backendRules.add(backendRulesItem);
        return this;
    }

    @ApiModelProperty(value="Serialized HAProxy rules to apply on server backend including request, response or header rewrite. acls also can be used. https://cbonte.github.io/haproxy-dconv/1.7/configuration.html#1")
    public List<String> getBackendRules() {
        return this.backendRules;
    }

    public void setBackendRules(List<String> backendRules) {
        this.backendRules = backendRules;
    }

    public V1beta1HTTPIngressBackend headerRules(List<String> headerRules) {
        this.headerRules = headerRules;
        return this;
    }

    public V1beta1HTTPIngressBackend addHeaderRulesItem(String headerRulesItem) {
        if (this.headerRules == null) {
            this.headerRules = new ArrayList<String>();
        }
        this.headerRules.add(headerRulesItem);
        return this;
    }

    @ApiModelProperty(value="Header rules to modifies the header.  Deprecated: Use backendRule, will be removed.")
    public List<String> getHeaderRules() {
        return this.headerRules;
    }

    public void setHeaderRules(List<String> headerRules) {
        this.headerRules = headerRules;
    }

    public V1beta1HTTPIngressBackend hostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    public V1beta1HTTPIngressBackend addHostNamesItem(String hostNamesItem) {
        if (this.hostNames == null) {
            this.hostNames = new ArrayList<String>();
        }
        this.hostNames.add(hostNamesItem);
        return this;
    }

    @ApiModelProperty(value="Host names to forward traffic to. If empty traffic will be forwarded to all subsets instance. If set only matched hosts will get the traffic. This is an handy way to send traffic to Specific StatefulSet pod. IE. Setting [web-0] will send traffic to only web-0 host for this StatefulSet, https://kubernetes.io/docs/tasks/stateful-application/basic-stateful-set/#creating-a-statefulset")
    public List<String> getHostNames() {
        return this.hostNames;
    }

    public void setHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
    }

    public V1beta1HTTPIngressBackend name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="User can specify backend name for using it with custom acl Otherwise it will be generated")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1HTTPIngressBackend rewriteRules(List<String> rewriteRules) {
        this.rewriteRules = rewriteRules;
        return this;
    }

    public V1beta1HTTPIngressBackend addRewriteRulesItem(String rewriteRulesItem) {
        if (this.rewriteRules == null) {
            this.rewriteRules = new ArrayList<String>();
        }
        this.rewriteRules.add(rewriteRulesItem);
        return this;
    }

    @ApiModelProperty(value="Path rewrite rules with haproxy formatted regex.  Deprecated: Use backendRule, will be removed.")
    public List<String> getRewriteRules() {
        return this.rewriteRules;
    }

    public void setRewriteRules(List<String> rewriteRules) {
        this.rewriteRules = rewriteRules;
    }

    public V1beta1HTTPIngressBackend serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(value="Specifies the name of the referenced service.")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public V1beta1HTTPIngressBackend servicePort(IntOrString servicePort) {
        this.servicePort = servicePort;
        return this;
    }

    @ApiModelProperty(value="Specifies the port of the referenced service.")
    public IntOrString getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(IntOrString servicePort) {
        this.servicePort = servicePort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1HTTPIngressBackend v1beta1HTTPIngressBackend = (V1beta1HTTPIngressBackend)o;
        return Objects.equals(this.backendRules, v1beta1HTTPIngressBackend.backendRules) && Objects.equals(this.headerRules, v1beta1HTTPIngressBackend.headerRules) && Objects.equals(this.hostNames, v1beta1HTTPIngressBackend.hostNames) && Objects.equals(this.name, v1beta1HTTPIngressBackend.name) && Objects.equals(this.rewriteRules, v1beta1HTTPIngressBackend.rewriteRules) && Objects.equals(this.serviceName, v1beta1HTTPIngressBackend.serviceName) && Objects.equals(this.servicePort, v1beta1HTTPIngressBackend.servicePort);
    }

    public int hashCode() {
        return Objects.hash(this.backendRules, this.headerRules, this.hostNames, this.name, this.rewriteRules, this.serviceName, this.servicePort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1HTTPIngressBackend {\n");
        sb.append("    backendRules: ").append(this.toIndentedString(this.backendRules)).append("\n");
        sb.append("    headerRules: ").append(this.toIndentedString(this.headerRules)).append("\n");
        sb.append("    hostNames: ").append(this.toIndentedString(this.hostNames)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    rewriteRules: ").append(this.toIndentedString(this.rewriteRules)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    servicePort: ").append(this.toIndentedString(this.servicePort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

