/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.voyager.client.models;

import com.appscode.voyager.client.models.V1beta1HTTPIngressPath;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.IntOrString;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="HTTPIngressRuleValue is a list of http selectors pointing to backends. In the example: http://<host>/<path>?<searchpart> -> backend where where parts of the url correspond to RFC 3986, this resource will be used to match against everything after the last '/' and before the first '?' or '#'.")
public class V1beta1HTTPIngressRuleValue {
    @SerializedName(value="address")
    private String address = null;
    @SerializedName(value="alpn")
    private List<String> alpn = null;
    @SerializedName(value="noTLS")
    private Boolean noTLS = null;
    @SerializedName(value="nodePort")
    private IntOrString nodePort = null;
    @SerializedName(value="paths")
    private List<V1beta1HTTPIngressPath> paths = new ArrayList<V1beta1HTTPIngressPath>();
    @SerializedName(value="port")
    private IntOrString port = null;

    public V1beta1HTTPIngressRuleValue address(String address) {
        this.address = address;
        return this;
    }

    @ApiModelProperty(value="The network address to listen HTTP(s) connections on.")
    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public V1beta1HTTPIngressRuleValue alpn(List<String> alpn) {
        this.alpn = alpn;
        return this;
    }

    public V1beta1HTTPIngressRuleValue addAlpnItem(String alpnItem) {
        if (this.alpn == null) {
            this.alpn = new ArrayList<String>();
        }
        this.alpn.add(alpnItem);
        return this;
    }

    @ApiModelProperty(value="Application-Layer Protocol Negotiation (ALPN) is a Transport Layer Security (TLS) extension for application layer protocol negotiation. ALPN allows the application layer to negotiate which protocol should be performed over a secure connection in a manner which avoids additional round trips and which is independent of the application layer protocols. It is used by HTTP/2. If provided a list of alpn will be added to port as alpn option1,option2,... If SecretName is Provided this secret will be used to terminate SSL with alpn options. If Secret name is not provided backend server is responsible for handling SSL.")
    public List<String> getAlpn() {
        return this.alpn;
    }

    public void setAlpn(List<String> alpn) {
        this.alpn = alpn;
    }

    public V1beta1HTTPIngressRuleValue noTLS(Boolean noTLS) {
        this.noTLS = noTLS;
        return this;
    }

    @ApiModelProperty(value="Set noTLS = true to force plain text. Else, auto detect like present")
    public Boolean isNoTLS() {
        return this.noTLS;
    }

    public void setNoTLS(Boolean noTLS) {
        this.noTLS = noTLS;
    }

    public V1beta1HTTPIngressRuleValue nodePort(IntOrString nodePort) {
        this.nodePort = nodePort;
        return this;
    }

    @ApiModelProperty(value="Specifies the node port of the referenced service.")
    public IntOrString getNodePort() {
        return this.nodePort;
    }

    public void setNodePort(IntOrString nodePort) {
        this.nodePort = nodePort;
    }

    public V1beta1HTTPIngressRuleValue paths(List<V1beta1HTTPIngressPath> paths) {
        this.paths = paths;
        return this;
    }

    public V1beta1HTTPIngressRuleValue addPathsItem(V1beta1HTTPIngressPath pathsItem) {
        this.paths.add(pathsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="A collection of paths that map requests to backends.")
    public List<V1beta1HTTPIngressPath> getPaths() {
        return this.paths;
    }

    public void setPaths(List<V1beta1HTTPIngressPath> paths) {
        this.paths = paths;
    }

    public V1beta1HTTPIngressRuleValue port(IntOrString port) {
        this.port = port;
        return this;
    }

    @ApiModelProperty(value="port to listen http(s) connections.")
    public IntOrString getPort() {
        return this.port;
    }

    public void setPort(IntOrString port) {
        this.port = port;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1HTTPIngressRuleValue v1beta1HTTPIngressRuleValue = (V1beta1HTTPIngressRuleValue)o;
        return Objects.equals(this.address, v1beta1HTTPIngressRuleValue.address) && Objects.equals(this.alpn, v1beta1HTTPIngressRuleValue.alpn) && Objects.equals(this.noTLS, v1beta1HTTPIngressRuleValue.noTLS) && Objects.equals(this.nodePort, v1beta1HTTPIngressRuleValue.nodePort) && Objects.equals(this.paths, v1beta1HTTPIngressRuleValue.paths) && Objects.equals(this.port, v1beta1HTTPIngressRuleValue.port);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.alpn, this.noTLS, this.nodePort, this.paths, this.port);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1HTTPIngressRuleValue {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    alpn: ").append(this.toIndentedString(this.alpn)).append("\n");
        sb.append("    noTLS: ").append(this.toIndentedString(this.noTLS)).append("\n");
        sb.append("    nodePort: ").append(this.toIndentedString(this.nodePort)).append("\n");
        sb.append("    paths: ").append(this.toIndentedString(this.paths)).append("\n");
        sb.append("    port: ").append(this.toIndentedString(this.port)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

