/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.voyager.client.models;

import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.custom.IntOrString;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@ApiModel(description="IngressBackend describes all endpoints for a given service and port.")
public class V1beta1IngressBackend {
    @SerializedName(value="backendRules")
    private List<String> backendRules = null;
    @SerializedName(value="hostNames")
    private List<String> hostNames = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="serviceName")
    private String serviceName = null;
    @SerializedName(value="servicePort")
    private IntOrString servicePort = null;

    public V1beta1IngressBackend backendRules(List<String> backendRules) {
        this.backendRules = backendRules;
        return this;
    }

    public V1beta1IngressBackend addBackendRulesItem(String backendRulesItem) {
        if (this.backendRules == null) {
            this.backendRules = new ArrayList<String>();
        }
        this.backendRules.add(backendRulesItem);
        return this;
    }

    @ApiModelProperty(value="Serialized HAProxy rules to apply on server backend including request, response or header rewrite. acls also can be used. https://cbonte.github.io/haproxy-dconv/1.7/configuration.html#1")
    public List<String> getBackendRules() {
        return this.backendRules;
    }

    public void setBackendRules(List<String> backendRules) {
        this.backendRules = backendRules;
    }

    public V1beta1IngressBackend hostNames(List<String> hostNames) {
        this.hostNames = hostNames;
        return this;
    }

    public V1beta1IngressBackend addHostNamesItem(String hostNamesItem) {
        if (this.hostNames == null) {
            this.hostNames = new ArrayList<String>();
        }
        this.hostNames.add(hostNamesItem);
        return this;
    }

    @ApiModelProperty(value="Host names to forward traffic to. If empty traffic will be forwarded to all subsets instance. If set only matched hosts will get the traffic. This is an handy way to send traffic to Specific StatefulSet pod. IE. Setting [web-0] will send traffic to only web-0 host for this StatefulSet, https://kubernetes.io/docs/tasks/stateful-application/basic-stateful-set/#creating-a-statefulset")
    public List<String> getHostNames() {
        return this.hostNames;
    }

    public void setHostNames(List<String> hostNames) {
        this.hostNames = hostNames;
    }

    public V1beta1IngressBackend name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(value="User can specify backend name for using it with custom acl Otherwise it will be generated")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public V1beta1IngressBackend serviceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    @ApiModelProperty(value="Specifies the name of the referenced service.")
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public V1beta1IngressBackend servicePort(IntOrString servicePort) {
        this.servicePort = servicePort;
        return this;
    }

    @ApiModelProperty(value="Specifies the port of the referenced service.")
    public IntOrString getServicePort() {
        return this.servicePort;
    }

    public void setServicePort(IntOrString servicePort) {
        this.servicePort = servicePort;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1IngressBackend v1beta1IngressBackend = (V1beta1IngressBackend)o;
        return Objects.equals(this.backendRules, v1beta1IngressBackend.backendRules) && Objects.equals(this.hostNames, v1beta1IngressBackend.hostNames) && Objects.equals(this.name, v1beta1IngressBackend.name) && Objects.equals(this.serviceName, v1beta1IngressBackend.serviceName) && Objects.equals(this.servicePort, v1beta1IngressBackend.servicePort);
    }

    public int hashCode() {
        return Objects.hash(this.backendRules, this.hostNames, this.name, this.serviceName, this.servicePort);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1IngressBackend {\n");
        sb.append("    backendRules: ").append(this.toIndentedString(this.backendRules)).append("\n");
        sb.append("    hostNames: ").append(this.toIndentedString(this.hostNames)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    serviceName: ").append(this.toIndentedString(this.serviceName)).append("\n");
        sb.append("    servicePort: ").append(this.toIndentedString(this.servicePort)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

