/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.voyager.client.models;

import com.appscode.voyager.client.models.V1beta1FrontendRule;
import com.appscode.voyager.client.models.V1beta1HTTPIngressBackend;
import com.appscode.voyager.client.models.V1beta1IngressRule;
import com.appscode.voyager.client.models.V1beta1IngressTLS;
import com.google.gson.annotations.SerializedName;
import io.kubernetes.client.models.V1Affinity;
import io.kubernetes.client.models.V1LocalObjectReference;
import io.kubernetes.client.models.V1ResourceRequirements;
import io.kubernetes.client.models.V1Toleration;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@ApiModel(description="IngressSpec describes the Ingress the user wishes to exist.")
public class V1beta1IngressSpec {
    @SerializedName(value="affinity")
    private V1Affinity affinity = null;
    @SerializedName(value="backend")
    private V1beta1HTTPIngressBackend backend = null;
    @SerializedName(value="externalIPs")
    private List<String> externalIPs = null;
    @SerializedName(value="frontendRules")
    private List<V1beta1FrontendRule> frontendRules = null;
    @SerializedName(value="imagePullSecrets")
    private List<V1LocalObjectReference> imagePullSecrets = null;
    @SerializedName(value="loadBalancerSourceRanges")
    private List<String> loadBalancerSourceRanges = null;
    @SerializedName(value="nodeSelector")
    private Map<String, String> nodeSelector = null;
    @SerializedName(value="resources")
    private V1ResourceRequirements resources = null;
    @SerializedName(value="rules")
    private List<V1beta1IngressRule> rules = null;
    @SerializedName(value="schedulerName")
    private String schedulerName = null;
    @SerializedName(value="tls")
    private List<V1beta1IngressTLS> tls = null;
    @SerializedName(value="tolerations")
    private List<V1Toleration> tolerations = null;

    public V1beta1IngressSpec affinity(V1Affinity affinity) {
        this.affinity = affinity;
        return this;
    }

    @ApiModelProperty(value="If specified, the pod's scheduling constraints")
    public V1Affinity getAffinity() {
        return this.affinity;
    }

    public void setAffinity(V1Affinity affinity) {
        this.affinity = affinity;
    }

    public V1beta1IngressSpec backend(V1beta1HTTPIngressBackend backend) {
        this.backend = backend;
        return this;
    }

    @ApiModelProperty(value="A default backend capable of servicing requests that don't match any rule. At least one of 'backend' or 'rules' must be specified. This field is optional to allow the loadbalancer controller or defaulting logic to specify a global default.")
    public V1beta1HTTPIngressBackend getBackend() {
        return this.backend;
    }

    public void setBackend(V1beta1HTTPIngressBackend backend) {
        this.backend = backend;
    }

    public V1beta1IngressSpec externalIPs(List<String> externalIPs) {
        this.externalIPs = externalIPs;
        return this;
    }

    public V1beta1IngressSpec addExternalIPsItem(String externalIPsItem) {
        if (this.externalIPs == null) {
            this.externalIPs = new ArrayList<String>();
        }
        this.externalIPs.add(externalIPsItem);
        return this;
    }

    @ApiModelProperty(value="externalIPs is a list of IP addresses for which nodes in the cluster will also accept traffic for this service.  These IPs are not managed by Kubernetes.  The user is responsible for ensuring that traffic arrives at a node with this IP.  A common example is external load-balancers that are not part of the Kubernetes system.")
    public List<String> getExternalIPs() {
        return this.externalIPs;
    }

    public void setExternalIPs(List<String> externalIPs) {
        this.externalIPs = externalIPs;
    }

    public V1beta1IngressSpec frontendRules(List<V1beta1FrontendRule> frontendRules) {
        this.frontendRules = frontendRules;
        return this;
    }

    public V1beta1IngressSpec addFrontendRulesItem(V1beta1FrontendRule frontendRulesItem) {
        if (this.frontendRules == null) {
            this.frontendRules = new ArrayList<V1beta1FrontendRule>();
        }
        this.frontendRules.add(frontendRulesItem);
        return this;
    }

    @ApiModelProperty(value="Frontend rules specifies a set of rules that should be applied in HAProxy frontend configuration. The set of keywords are from here https://cbonte.github.io/haproxy-dconv/1.7/configuration.html#4.1 Only frontend sections can be applied here. It is up to user to provide valid set of rules. This allows acls or other options in frontend sections in HAProxy config. Frontend rules will be mapped with Ingress Rules according to port.")
    public List<V1beta1FrontendRule> getFrontendRules() {
        return this.frontendRules;
    }

    public void setFrontendRules(List<V1beta1FrontendRule> frontendRules) {
        this.frontendRules = frontendRules;
    }

    public V1beta1IngressSpec imagePullSecrets(List<V1LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
        return this;
    }

    public V1beta1IngressSpec addImagePullSecretsItem(V1LocalObjectReference imagePullSecretsItem) {
        if (this.imagePullSecrets == null) {
            this.imagePullSecrets = new ArrayList<V1LocalObjectReference>();
        }
        this.imagePullSecrets.add(imagePullSecretsItem);
        return this;
    }

    @ApiModelProperty(value="ImagePullSecrets is an optional list of references to secrets in the same namespace to use for pulling any of the images used by this PodSpec. If specified, these secrets will be passed to individual puller implementations for them to use. For example, in the case of docker, only DockerConfig type secrets are honored. More info: https://kubernetes.io/docs/concepts/containers/images#specifying-imagepullsecrets-on-a-pod")
    public List<V1LocalObjectReference> getImagePullSecrets() {
        return this.imagePullSecrets;
    }

    public void setImagePullSecrets(List<V1LocalObjectReference> imagePullSecrets) {
        this.imagePullSecrets = imagePullSecrets;
    }

    public V1beta1IngressSpec loadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
        return this;
    }

    public V1beta1IngressSpec addLoadBalancerSourceRangesItem(String loadBalancerSourceRangesItem) {
        if (this.loadBalancerSourceRanges == null) {
            this.loadBalancerSourceRanges = new ArrayList<String>();
        }
        this.loadBalancerSourceRanges.add(loadBalancerSourceRangesItem);
        return this;
    }

    @ApiModelProperty(value="Optional: If specified and supported by the platform, this will restrict traffic through the cloud-provider load-balancer will be restricted to the specified client IPs. This field will be ignored if the cloud-provider does not support the feature. https://kubernetes.io/docs/tasks/access-application-cluster/configure-cloud-provider-firewall/")
    public List<String> getLoadBalancerSourceRanges() {
        return this.loadBalancerSourceRanges;
    }

    public void setLoadBalancerSourceRanges(List<String> loadBalancerSourceRanges) {
        this.loadBalancerSourceRanges = loadBalancerSourceRanges;
    }

    public V1beta1IngressSpec nodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
        return this;
    }

    public V1beta1IngressSpec putNodeSelectorItem(String key, String nodeSelectorItem) {
        if (this.nodeSelector == null) {
            this.nodeSelector = new HashMap<String, String>();
        }
        this.nodeSelector.put(key, nodeSelectorItem);
        return this;
    }

    @ApiModelProperty(value="NodeSelector is a selector which must be true for the pod to fit on a node. Selector which must match a node's labels for the pod to be scheduled on that node. More info: https://kubernetes.io/docs/concepts/configuration/assign-pod-node/")
    public Map<String, String> getNodeSelector() {
        return this.nodeSelector;
    }

    public void setNodeSelector(Map<String, String> nodeSelector) {
        this.nodeSelector = nodeSelector;
    }

    public V1beta1IngressSpec resources(V1ResourceRequirements resources) {
        this.resources = resources;
        return this;
    }

    @ApiModelProperty(value="Compute Resources required by the sidecar container.")
    public V1ResourceRequirements getResources() {
        return this.resources;
    }

    public void setResources(V1ResourceRequirements resources) {
        this.resources = resources;
    }

    public V1beta1IngressSpec rules(List<V1beta1IngressRule> rules) {
        this.rules = rules;
        return this;
    }

    public V1beta1IngressSpec addRulesItem(V1beta1IngressRule rulesItem) {
        if (this.rules == null) {
            this.rules = new ArrayList<V1beta1IngressRule>();
        }
        this.rules.add(rulesItem);
        return this;
    }

    @ApiModelProperty(value="A list of host rules used to configure the Ingress. If unspecified, or no rule matches, all traffic is sent to the default backend.")
    public List<V1beta1IngressRule> getRules() {
        return this.rules;
    }

    public void setRules(List<V1beta1IngressRule> rules) {
        this.rules = rules;
    }

    public V1beta1IngressSpec schedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
        return this;
    }

    @ApiModelProperty(value="If specified, the pod will be dispatched by specified scheduler. If not specified, the pod will be dispatched by default scheduler.")
    public String getSchedulerName() {
        return this.schedulerName;
    }

    public void setSchedulerName(String schedulerName) {
        this.schedulerName = schedulerName;
    }

    public V1beta1IngressSpec tls(List<V1beta1IngressTLS> tls) {
        this.tls = tls;
        return this;
    }

    public V1beta1IngressSpec addTlsItem(V1beta1IngressTLS tlsItem) {
        if (this.tls == null) {
            this.tls = new ArrayList<V1beta1IngressTLS>();
        }
        this.tls.add(tlsItem);
        return this;
    }

    @ApiModelProperty(value="TLS is the TLS configuration. Currently the Ingress only supports a single TLS port, 443, and assumes TLS termination. If multiple members of this list specify different hosts, they will be multiplexed on the same port according to the hostname specified through the SNI TLS extension.")
    public List<V1beta1IngressTLS> getTls() {
        return this.tls;
    }

    public void setTls(List<V1beta1IngressTLS> tls) {
        this.tls = tls;
    }

    public V1beta1IngressSpec tolerations(List<V1Toleration> tolerations) {
        this.tolerations = tolerations;
        return this;
    }

    public V1beta1IngressSpec addTolerationsItem(V1Toleration tolerationsItem) {
        if (this.tolerations == null) {
            this.tolerations = new ArrayList<V1Toleration>();
        }
        this.tolerations.add(tolerationsItem);
        return this;
    }

    @ApiModelProperty(value="If specified, the pod's tolerations.")
    public List<V1Toleration> getTolerations() {
        return this.tolerations;
    }

    public void setTolerations(List<V1Toleration> tolerations) {
        this.tolerations = tolerations;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        V1beta1IngressSpec v1beta1IngressSpec = (V1beta1IngressSpec)o;
        return Objects.equals(this.affinity, v1beta1IngressSpec.affinity) && Objects.equals(this.backend, v1beta1IngressSpec.backend) && Objects.equals(this.externalIPs, v1beta1IngressSpec.externalIPs) && Objects.equals(this.frontendRules, v1beta1IngressSpec.frontendRules) && Objects.equals(this.imagePullSecrets, v1beta1IngressSpec.imagePullSecrets) && Objects.equals(this.loadBalancerSourceRanges, v1beta1IngressSpec.loadBalancerSourceRanges) && Objects.equals(this.nodeSelector, v1beta1IngressSpec.nodeSelector) && Objects.equals(this.resources, v1beta1IngressSpec.resources) && Objects.equals(this.rules, v1beta1IngressSpec.rules) && Objects.equals(this.schedulerName, v1beta1IngressSpec.schedulerName) && Objects.equals(this.tls, v1beta1IngressSpec.tls) && Objects.equals(this.tolerations, v1beta1IngressSpec.tolerations);
    }

    public int hashCode() {
        return Objects.hash(this.affinity, this.backend, this.externalIPs, this.frontendRules, this.imagePullSecrets, this.loadBalancerSourceRanges, this.nodeSelector, this.resources, this.rules, this.schedulerName, this.tls, this.tolerations);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class V1beta1IngressSpec {\n");
        sb.append("    affinity: ").append(this.toIndentedString(this.affinity)).append("\n");
        sb.append("    backend: ").append(this.toIndentedString(this.backend)).append("\n");
        sb.append("    externalIPs: ").append(this.toIndentedString(this.externalIPs)).append("\n");
        sb.append("    frontendRules: ").append(this.toIndentedString(this.frontendRules)).append("\n");
        sb.append("    imagePullSecrets: ").append(this.toIndentedString(this.imagePullSecrets)).append("\n");
        sb.append("    loadBalancerSourceRanges: ").append(this.toIndentedString(this.loadBalancerSourceRanges)).append("\n");
        sb.append("    nodeSelector: ").append(this.toIndentedString(this.nodeSelector)).append("\n");
        sb.append("    resources: ").append(this.toIndentedString(this.resources)).append("\n");
        sb.append("    rules: ").append(this.toIndentedString(this.rules)).append("\n");
        sb.append("    schedulerName: ").append(this.toIndentedString(this.schedulerName)).append("\n");
        sb.append("    tls: ").append(this.toIndentedString(this.tls)).append("\n");
        sb.append("    tolerations: ").append(this.toIndentedString(this.tolerations)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

