/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.voyager.client.util;

import com.appscode.voyager.client.ApiClient;
import com.appscode.voyager.client.util.ClientBuilder;
import com.appscode.voyager.client.util.KubeConfig;
import com.appscode.voyager.client.util.credentials.AccessTokenAuthentication;
import com.appscode.voyager.client.util.credentials.UsernamePasswordAuthentication;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Config {
    private static final Logger log = LoggerFactory.getLogger(Config.class);
    public static final String SERVICEACCOUNT_ROOT = "/var/run/secrets/kubernetes.io/serviceaccount";
    public static final String SERVICEACCOUNT_CA_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/ca.crt";
    public static final String SERVICEACCOUNT_TOKEN_PATH = "/var/run/secrets/kubernetes.io/serviceaccount/token";
    public static final String ENV_KUBECONFIG = "KUBECONFIG";
    public static final String ENV_SERVICE_HOST = "KUBERNETES_SERVICE_HOST";
    public static final String ENV_SERVICE_PORT = "KUBERNETES_SERVICE_PORT";
    public static final String DEFAULT_FALLBACK_HOST = "http://localhost:8080";

    public static ApiClient fromCluster() throws IOException {
        return ClientBuilder.cluster().build();
    }

    public static ApiClient fromUrl(String url) {
        return Config.fromUrl(url, true);
    }

    public static ApiClient fromUrl(String url, boolean validateSSL) {
        return new ApiClient().setBasePath(url).setVerifyingSsl(validateSSL);
    }

    public static ApiClient fromUserPassword(String url, String user, String password) {
        return Config.fromUserPassword(url, user, password, true);
    }

    public static ApiClient fromUserPassword(String url, String user, String password, boolean validateSSL) {
        return new ClientBuilder().setBasePath(url).setAuthentication(new UsernamePasswordAuthentication(user, password)).setVerifyingSsl(validateSSL).build();
    }

    public static ApiClient fromToken(String url, String token) {
        return Config.fromToken(url, token, true);
    }

    public static ApiClient fromToken(String url, String token, boolean validateSSL) {
        return new ClientBuilder().setBasePath(url).setAuthentication(new AccessTokenAuthentication(token)).setVerifyingSsl(validateSSL).build();
    }

    public static ApiClient fromConfig(String fileName) throws IOException {
        return Config.fromConfig(new FileReader(fileName));
    }

    public static ApiClient fromConfig(InputStream stream) throws IOException {
        return Config.fromConfig(new InputStreamReader(stream));
    }

    public static ApiClient fromConfig(Reader input) throws IOException {
        return Config.fromConfig(KubeConfig.loadKubeConfig(input));
    }

    public static ApiClient fromConfig(KubeConfig config) throws IOException {
        return ClientBuilder.kubeconfig(config).build();
    }

    public static ApiClient defaultClient() throws IOException {
        return ClientBuilder.standard().build();
    }
}

