/*
 * Decompiled with CFR 0.152.
 */
package com.appscode.voyager.client.util.authenticators;

import com.appscode.voyager.client.util.KubeConfig;
import com.appscode.voyager.client.util.authenticators.Authenticator;
import java.util.Date;
import java.util.Map;

public class AzureActiveDirectoryAuthenticator
implements Authenticator {
    private static final String ACCESS_TOKEN = "access-token";
    private static final String EXPIRES_ON = "expires-on";

    @Override
    public String getName() {
        return "azure";
    }

    @Override
    public String getToken(Map<String, Object> config) {
        return (String)config.get(ACCESS_TOKEN);
    }

    @Override
    public boolean isExpired(Map<String, Object> config) {
        String expiresOn = (String)config.get(EXPIRES_ON);
        Date expiry = new Date(Long.parseLong(expiresOn) * 1000L);
        return expiry != null && expiry.compareTo(new Date()) <= 0;
    }

    @Override
    public Map<String, Object> refresh(Map<String, Object> config) {
        throw new RuntimeException("Unimplemented");
    }

    static {
        KubeConfig.registerAuthenticator(new AzureActiveDirectoryAuthenticator());
    }
}

