/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.processor.model.impl;

import com.atomgraph.processor.model.Parameter;
import com.atomgraph.processor.vocabulary.LDT;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spinrdf.model.impl.ArgumentImpl;

public class ParameterImpl
extends ArgumentImpl
implements Parameter {
    private static final Logger log = LoggerFactory.getLogger(ParameterImpl.class);
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new ParameterImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to Parameter: it does not have rdf:type ldt:Parameter or equivalent");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            if (eg == null) {
                throw new IllegalArgumentException("EnhGraph cannot be null");
            }
            return eg.asGraph().contains(node, RDF.type.asNode(), LDT.Parameter.asNode());
        }
    };

    public ParameterImpl(Node node, EnhGraph enhGraph) {
        super(node, enhGraph);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("[<").append(this.getPredicate().getURI()).append(">");
        if (this.getDefaultValue() != null) {
            sb.append(", ").append(this.getDefaultValue());
        }
        if (this.getValueType() != null) {
            sb.append(", ").append(this.getValueType());
        }
        sb.append("]");
        return sb.toString();
    }
}

