/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.processor.model.impl;

import com.atomgraph.processor.exception.OntologyException;
import com.atomgraph.processor.model.Parameter;
import com.atomgraph.processor.model.Template;
import com.atomgraph.processor.vocabulary.LDT;
import com.sun.jersey.api.uri.UriTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.ws.rs.core.CacheControl;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.enhanced.EnhNode;
import org.apache.jena.enhanced.Implementation;
import org.apache.jena.graph.Node;
import org.apache.jena.ontology.ConversionException;
import org.apache.jena.ontology.impl.OntClassImpl;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFList;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateImpl
extends OntClassImpl
implements Template {
    private static final Logger log = LoggerFactory.getLogger(TemplateImpl.class);
    public static Implementation factory = new Implementation(){

        public EnhNode wrap(Node node, EnhGraph enhGraph) {
            if (this.canWrap(node, enhGraph)) {
                return new TemplateImpl(node, enhGraph);
            }
            throw new ConversionException("Cannot convert node " + node.toString() + " to Template: it does not have rdf:type ldt:Template or equivalent");
        }

        public boolean canWrap(Node node, EnhGraph eg) {
            if (eg == null) {
                throw new IllegalArgumentException("EnhGraph cannot be null");
            }
            return eg.asGraph().contains(node, RDF.type.asNode(), LDT.Template.asNode());
        }
    };

    public TemplateImpl(Node n, EnhGraph g) {
        super(n, g);
    }

    @Override
    public UriTemplate getMatch() {
        Statement path = this.getProperty((Property)LDT.match);
        if (path != null) {
            if (!path.getObject().isLiteral() || path.getObject().asLiteral().getDatatype() == null || !path.getObject().asLiteral().getDatatype().equals(XSDDatatype.XSDstring)) {
                if (log.isErrorEnabled()) {
                    log.error("Class {} property {} is not an xsd:string literal", (Object)this.getURI(), (Object)LDT.match);
                }
                throw new OntologyException("Class '" + this.getURI() + "' property '" + LDT.match + "' is not an xsd:string literal");
            }
            return new UriTemplate(path.getString());
        }
        return null;
    }

    @Override
    public String getFragmentTemplate() {
        return this.getStringValue((Property)LDT.fragment);
    }

    @Override
    public Resource getQuery() {
        return this.getPropertyResourceValue((Property)LDT.query);
    }

    @Override
    public Resource getUpdate() {
        return this.getPropertyResourceValue((Property)LDT.update);
    }

    @Override
    public Double getPriority() {
        Statement priority = this.getProperty((Property)LDT.priority);
        if (priority != null) {
            return priority.getDouble();
        }
        return 0.0;
    }

    @Override
    public Map<Property, Parameter> getParameters() {
        return this.addSuperParameters(this, this.getLocalParameters());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Property, Parameter> getLocalParameters() {
        HashMap<Property, Parameter> params = new HashMap<Property, Parameter>();
        try (StmtIterator it = this.listProperties((Property)LDT.param);){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                if (!stmt.getObject().canAs(Parameter.class)) {
                    if (log.isErrorEnabled()) {
                        log.error("Unsupported Argument '{}' for Template '{}' (rdf:type ldt:Parameter missing)", (Object)stmt.getObject(), (Object)this.getURI());
                    }
                    throw new OntologyException("Unsupported Argument '" + stmt.getObject() + "' for Template '" + this.getURI() + "' (rdf:type ldt:Parameter missing)");
                }
                Parameter param = (Parameter)stmt.getObject().as(Parameter.class);
                if (params.containsKey(param.getPredicate())) {
                    if (log.isErrorEnabled()) {
                        log.error("Multiple Arguments with the same predicate '{}' for Template '{}' ", (Object)param.getPredicate(), (Object)this.getURI());
                    }
                    throw new OntologyException("Multiple Arguments with the same predicate '" + param.getPredicate() + "' for Template '" + this.getURI() + "'");
                }
                params.put(param.getPredicate(), param);
            }
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<Property, Parameter> addSuperParameters(Template template, Map<Property, Parameter> params) {
        if (template == null) {
            throw new IllegalArgumentException("Template Set cannot be null");
        }
        if (params == null) {
            throw new IllegalArgumentException("Parameter Map cannot be null");
        }
        try (StmtIterator it = template.listProperties((Property)LDT.extends_);){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                if (!stmt.getObject().isResource() || !stmt.getObject().asResource().canAs(Template.class)) {
                    if (log.isErrorEnabled()) {
                        log.error("Template's '{}' ldt:extends value '{}' is not an LDT Template", (Object)this.getURI(), (Object)stmt.getObject());
                    }
                    throw new OntologyException("Template's '" + this.getURI() + "' ldt:extends value '" + stmt.getObject() + "' is not an LDT Template");
                }
                Template superTemplate = (Template)stmt.getObject().as(Template.class);
                Map<Property, Parameter> superArgs = superTemplate.getLocalParameters();
                for (Map.Entry<Property, Parameter> entry : superArgs.entrySet()) {
                    params.putIfAbsent(entry.getKey(), entry.getValue());
                }
                this.addSuperParameters(superTemplate, params);
            }
        }
        return params;
    }

    @Override
    public Map<String, Parameter> getParameterMap() {
        HashMap<String, Parameter> map = new HashMap<String, Parameter>();
        for (Parameter param : this.getParameters().values()) {
            Property property = param.getPredicate();
            if (property == null) continue;
            map.put(property.getLocalName(), param);
        }
        return map;
    }

    @Override
    public List<Locale> getLanguages() {
        return this.getLanguages((Property)LDT.lang);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Locale> getLanguages(Property property) {
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        ArrayList<Locale> languages = new ArrayList<Locale>();
        Resource langs = this.getPropertyResourceValue(property);
        if (langs != null) {
            if (!langs.canAs(RDFList.class)) {
                if (log.isErrorEnabled()) {
                    log.error("ldt:lang value is not an rdf:List on template '{}'", (Object)this.getURI());
                }
                throw new OntologyException("ldt:lang value is not an rdf:List on template  '" + this.getURI() + "'");
            }
            RDFList list = (RDFList)langs.as(RDFList.class);
            try (ExtendedIterator it = list.iterator();){
                while (it.hasNext()) {
                    RDFNode langTag = (RDFNode)it.next();
                    if (!langTag.isLiteral()) {
                        if (log.isErrorEnabled()) {
                            log.error("Non-literal language tag (ldt:lang member) on template '{}'", (Object)this.getURI());
                        }
                        throw new OntologyException("Non-literal language tag (ldt:lang member) on template '" + this.getURI() + "'");
                    }
                    languages.add(Locale.forLanguageTag(langTag.asLiteral().getString()));
                }
            }
        }
        return languages;
    }

    @Override
    public Resource getLoadClass() {
        return this.getPropertyResourceValue((Property)LDT.loadClass);
    }

    @Override
    public CacheControl getCacheControl() {
        if (this.hasProperty((Property)LDT.cacheControl)) {
            return CacheControl.valueOf((String)this.getPropertyValue((Property)LDT.cacheControl).asLiteral().getString());
        }
        return null;
    }

    protected String getStringValue(Property property) {
        if (property == null) {
            throw new IllegalArgumentException("Property cannot be null");
        }
        if (this.hasProperty(property) && this.getPropertyValue(property).isLiteral()) {
            return this.getPropertyValue(property).asLiteral().getString();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean hasSuperTemplate(Template superTemplate) {
        if (superTemplate == null) {
            throw new IllegalArgumentException("Template cannot be null");
        }
        try (StmtIterator it = this.listProperties((Property)LDT.extends_);){
            while (it.hasNext()) {
                Statement stmt = (Statement)it.next();
                if (!stmt.getObject().isResource() || !stmt.getObject().asResource().canAs(Template.class)) {
                    if (log.isErrorEnabled()) {
                        log.error("Template's '{}' ldt:extends value '{}' is not an LDT Template", (Object)this.getURI(), (Object)stmt.getObject());
                    }
                    throw new OntologyException("Template's '" + this.getURI() + "' ldt:extends value '" + stmt.getObject() + "' is not an LDT Template");
                }
                Template nextTemplate = (Template)stmt.getObject().as(Template.class);
                if (!nextTemplate.equals(superTemplate) && !nextTemplate.hasSuperTemplate(superTemplate)) continue;
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    public String toString() {
        return "[<" + this.getURI() + ">: \"" + this.getMatch() + "\", " + Double.toString(this.getPriority()) + "]";
    }
}

