/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.exception.ConfigurationException;
import com.atomgraph.core.io.QueryProvider;
import com.atomgraph.core.io.ResultSetProvider;
import com.atomgraph.core.io.UpdateRequestReader;
import com.atomgraph.core.model.Service;
import com.atomgraph.core.model.impl.remote.ServiceImpl;
import com.atomgraph.core.provider.DataManagerProvider;
import com.atomgraph.core.provider.MediaTypesProvider;
import com.atomgraph.core.provider.QueryParamProvider;
import com.atomgraph.core.provider.ServiceProvider;
import com.atomgraph.core.util.jena.DataManager;
import com.atomgraph.core.vocabulary.A;
import com.atomgraph.core.vocabulary.SD;
import com.atomgraph.processor.model.Parameter;
import com.atomgraph.processor.model.Template;
import com.atomgraph.processor.model.impl.ApplicationImpl;
import com.atomgraph.processor.model.impl.ParameterImpl;
import com.atomgraph.processor.model.impl.TemplateImpl;
import com.atomgraph.processor.vocabulary.AP;
import com.atomgraph.processor.vocabulary.LDT;
import com.atomgraph.server.io.SkolemizingDatasetProvider;
import com.atomgraph.server.io.SkolemizingModelProvider;
import com.atomgraph.server.mapper.ClientExceptionMapper;
import com.atomgraph.server.mapper.ConfigurationExceptionMapper;
import com.atomgraph.server.mapper.ConstraintViolationExceptionMapper;
import com.atomgraph.server.mapper.ModelExceptionMapper;
import com.atomgraph.server.mapper.NotFoundExceptionMapper;
import com.atomgraph.server.mapper.OntologyExceptionMapper;
import com.atomgraph.server.mapper.ParameterExceptionMapper;
import com.atomgraph.server.mapper.jena.DatatypeFormatExceptionMapper;
import com.atomgraph.server.mapper.jena.QueryParseExceptionMapper;
import com.atomgraph.server.mapper.jena.RiotExceptionMapper;
import com.atomgraph.server.model.impl.ResourceBase;
import com.atomgraph.server.provider.ApplicationProvider;
import com.atomgraph.server.provider.OntologyProvider;
import com.atomgraph.server.provider.TemplateCallProvider;
import com.atomgraph.server.provider.TemplateProvider;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.ServletConfig;
import javax.ws.rs.core.Context;
import org.apache.jena.enhanced.BuiltinPersonalities;
import org.apache.jena.ontology.OntDocumentManager;
import org.apache.jena.ontology.OntModelSpec;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.ResourceFactory;
import org.apache.jena.reasoner.Reasoner;
import org.apache.jena.reasoner.rulesys.GenericRuleReasoner;
import org.apache.jena.reasoner.rulesys.Rule;
import org.apache.jena.util.FileManager;
import org.apache.jena.util.LocationMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spinrdf.arq.ARQFactory;
import org.spinrdf.system.SPINModuleRegistry;

public class Application
extends com.atomgraph.core.Application {
    private static final Logger log = LoggerFactory.getLogger(Application.class);
    private final Set<Class<?>> classes = new HashSet();
    private final Set<Object> singletons = new HashSet<Object>();
    private final com.atomgraph.processor.model.Application application;
    private final Service service;
    private final String ontologyURI;
    private final OntModelSpec ontModelSpec;
    private final boolean cacheSitemap;

    public Application(@Context ServletConfig servletConfig) {
        this(servletConfig.getServletContext().getInitParameter(A.dataset.getURI()) != null ? Application.getDataset((String)servletConfig.getServletContext().getInitParameter(A.dataset.getURI()), null) : null, servletConfig.getServletContext().getInitParameter(SD.endpoint.getURI()) != null ? servletConfig.getServletContext().getInitParameter(SD.endpoint.getURI()) : null, servletConfig.getServletContext().getInitParameter(A.graphStore.getURI()) != null ? servletConfig.getServletContext().getInitParameter(A.graphStore.getURI()) : null, servletConfig.getServletContext().getInitParameter(A.quadStore.getURI()) != null ? servletConfig.getServletContext().getInitParameter(A.quadStore.getURI()) : null, servletConfig.getServletContext().getInitParameter(org.apache.jena.sparql.engine.http.Service.queryAuthUser.getSymbol()) != null ? servletConfig.getServletContext().getInitParameter(org.apache.jena.sparql.engine.http.Service.queryAuthUser.getSymbol()) : null, servletConfig.getServletContext().getInitParameter(org.apache.jena.sparql.engine.http.Service.queryAuthPwd.getSymbol()) != null ? servletConfig.getServletContext().getInitParameter(org.apache.jena.sparql.engine.http.Service.queryAuthPwd.getSymbol()) : null, new MediaTypes(), Application.getClient((ClientConfig)new DefaultClientConfig()), servletConfig.getServletContext().getInitParameter(A.maxGetRequestSize.getURI()) != null ? Integer.valueOf(Integer.parseInt(servletConfig.getServletContext().getInitParameter(A.maxGetRequestSize.getURI()))) : null, servletConfig.getServletContext().getInitParameter(A.preemptiveAuth.getURI()) != null ? Boolean.parseBoolean(servletConfig.getServletContext().getInitParameter(A.preemptiveAuth.getURI())) : false, new LocationMapper(servletConfig.getServletContext().getInitParameter(AP.locationMapping.getURI()) != null ? servletConfig.getServletContext().getInitParameter(AP.locationMapping.getURI()) : null), servletConfig.getServletContext().getInitParameter(LDT.ontology.getURI()) != null ? servletConfig.getServletContext().getInitParameter(LDT.ontology.getURI()) : null, servletConfig.getServletContext().getInitParameter(AP.sitemapRules.getURI()) != null ? servletConfig.getServletContext().getInitParameter(AP.sitemapRules.getURI()) : null, servletConfig.getServletContext().getInitParameter(AP.cacheSitemap.getURI()) != null ? Boolean.valueOf(servletConfig.getServletContext().getInitParameter(AP.cacheSitemap.getURI())) : true);
    }

    public Application(Dataset dataset, String endpointURI, String graphStoreURI, String quadStoreURI, String authUser, String authPwd, MediaTypes mediaTypes, Client client, Integer maxGetRequestSize, boolean preemptiveAuth, LocationMapper locationMapper, String ontologyURI, String rulesString, boolean cacheSitemap) {
        super(dataset, endpointURI, graphStoreURI, quadStoreURI, authUser, authPwd, mediaTypes, client, maxGetRequestSize, preemptiveAuth);
        if (locationMapper == null) {
            throw new IllegalArgumentException("LocationMapper be null");
        }
        if (ontologyURI == null) {
            if (log.isErrorEnabled()) {
                log.error("Sitemap ontology URI (" + LDT.ontology.getURI() + ") not configured");
            }
            throw new ConfigurationException((Property)LDT.ontology);
        }
        if (rulesString == null) {
            if (log.isErrorEnabled()) {
                log.error("Sitemap Rules (" + AP.sitemapRules.getURI() + ") not configured");
            }
            throw new ConfigurationException((Property)AP.sitemapRules);
        }
        this.ontologyURI = ontologyURI;
        this.cacheSitemap = cacheSitemap;
        if (dataset != null) {
            this.service = new com.atomgraph.core.model.impl.dataset.ServiceImpl(dataset, mediaTypes);
        } else {
            if (endpointURI == null) {
                if (log.isErrorEnabled()) {
                    log.error("SPARQL endpoint not configured ('{}' not set in web.xml)", (Object)SD.endpoint.getURI());
                }
                throw new ConfigurationException((Property)SD.endpoint);
            }
            if (graphStoreURI == null) {
                if (log.isErrorEnabled()) {
                    log.error("Graph Store not configured ('{}' not set in web.xml)", (Object)A.graphStore.getURI());
                }
                throw new ConfigurationException((Property)A.graphStore);
            }
            this.service = new ServiceImpl(client, mediaTypes, ResourceFactory.createResource((String)endpointURI), ResourceFactory.createResource((String)graphStoreURI), quadStoreURI != null ? ResourceFactory.createResource((String)quadStoreURI) : null, authUser, authPwd, maxGetRequestSize);
        }
        this.application = new ApplicationImpl(this.service, ResourceFactory.createResource((String)ontologyURI));
        List rules = Rule.parseRules((String)rulesString);
        OntModelSpec rulesSpec = new OntModelSpec(OntModelSpec.OWL_MEM);
        GenericRuleReasoner reasoner = new GenericRuleReasoner(rules);
        rulesSpec.setReasoner((Reasoner)reasoner);
        this.ontModelSpec = rulesSpec;
        BuiltinPersonalities.model.add(Parameter.class, ParameterImpl.factory);
        BuiltinPersonalities.model.add(Template.class, TemplateImpl.factory);
        SPINModuleRegistry.get().init();
        ARQFactory.get().setUseCaches(false);
        DataManager dataManager = new DataManager(locationMapper, client, mediaTypes, preemptiveAuth);
        FileManager.setStdLocators((FileManager)dataManager);
        FileManager.setGlobalFileManager((FileManager)dataManager);
        if (log.isDebugEnabled()) {
            log.debug("FileManager.get(): {}", (Object)FileManager.get());
        }
        OntDocumentManager.getInstance().setFileManager((FileManager)dataManager);
        if (log.isDebugEnabled()) {
            log.debug("OntDocumentManager.getInstance().getFileManager(): {}", (Object)OntDocumentManager.getInstance().getFileManager());
        }
        OntDocumentManager.getInstance().setCacheModels(cacheSitemap);
    }

    @PostConstruct
    public void init() {
        this.classes.add(ResourceBase.class);
        this.singletons.add(new ServiceProvider(this.getService()));
        this.singletons.add((Object)new ApplicationProvider(this.getApplication()));
        this.singletons.add((Object)new OntologyProvider(OntDocumentManager.getInstance(), this.getOntologyURI(), this.getOntModelSpec(), true));
        this.singletons.add((Object)new TemplateProvider());
        this.singletons.add((Object)new TemplateCallProvider());
        this.singletons.add((Object)new SkolemizingDatasetProvider());
        this.singletons.add((Object)new SkolemizingModelProvider());
        this.singletons.add(new ResultSetProvider());
        this.singletons.add(new QueryParamProvider());
        this.singletons.add(new QueryProvider());
        this.singletons.add(new UpdateRequestReader());
        this.singletons.add(new MediaTypesProvider(this.getMediaTypes()));
        this.singletons.add(new DataManagerProvider(this.getDataManager()));
        this.singletons.add(new RiotExceptionMapper());
        this.singletons.add(new ModelExceptionMapper());
        this.singletons.add(new ConstraintViolationExceptionMapper());
        this.singletons.add(new DatatypeFormatExceptionMapper());
        this.singletons.add(new NotFoundExceptionMapper());
        this.singletons.add(new ClientExceptionMapper());
        this.singletons.add(new ConfigurationExceptionMapper());
        this.singletons.add(new OntologyExceptionMapper());
        this.singletons.add(new ParameterExceptionMapper());
        this.singletons.add(new QueryParseExceptionMapper());
        if (log.isTraceEnabled()) {
            log.trace("Application.init() with Classes: {} and Singletons: {}", this.classes, this.singletons);
        }
    }

    public static FileManager getFileManager(LocationMapper locationMapper) {
        FileManager fileManager = FileManager.get();
        fileManager.setLocationMapper(locationMapper);
        return fileManager;
    }

    public Set<Class<?>> getClasses() {
        return this.classes;
    }

    public Set<Object> getSingletons() {
        return this.singletons;
    }

    public com.atomgraph.processor.model.Application getApplication() {
        return this.application;
    }

    public String getOntologyURI() {
        return this.ontologyURI;
    }

    public OntModelSpec getOntModelSpec() {
        return this.ontModelSpec;
    }

    public final boolean isCacheSitemap() {
        return this.cacheSitemap;
    }
}

