/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.io;

import com.atomgraph.processor.util.Skolemizer;
import com.atomgraph.server.exception.SkolemizationException;
import com.atomgraph.server.io.ValidatingDatasetProvider;
import java.util.Iterator;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.Dataset;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkolemizingDatasetProvider
extends ValidatingDatasetProvider {
    private static final Logger log = LoggerFactory.getLogger(SkolemizingDatasetProvider.class);
    @Context
    private Request request;
    @Context
    UriInfo uriInfo;

    @Override
    public Dataset process(Dataset dataset) {
        dataset = super.process(dataset);
        this.process(dataset.getDefaultModel());
        Iterator it = dataset.listNames();
        while (it.hasNext()) {
            String graphURI = (String)it.next();
            this.process(dataset.getNamedModel(graphURI));
        }
        return dataset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model process(Model model) {
        try (ResIterator it = model.listSubjects();){
            while (it.hasNext()) {
                Resource resource = (Resource)it.next();
                this.process(resource);
            }
        }
        return this.skolemize(this.getOntology(), this.getUriInfo().getBaseUriBuilder(), this.getUriInfo().getAbsolutePathBuilder(), model);
    }

    public Resource process(Resource resource) {
        return resource;
    }

    public Model skolemize(Ontology ontology, UriBuilder baseUriBuilder, UriBuilder absolutePathBuilder, Model model) {
        try {
            return new Skolemizer(ontology, baseUriBuilder, absolutePathBuilder).build(model);
        }
        catch (IllegalArgumentException ex) {
            throw new SkolemizationException(ex, model);
        }
    }

    public Request getRequest() {
        return this.request;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

