/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.io;

import com.atomgraph.processor.util.Skolemizer;
import com.atomgraph.server.exception.SkolemizationException;
import com.atomgraph.server.io.ValidatingModelProvider;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.UriBuilder;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ResIterator;
import org.apache.jena.rdf.model.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SkolemizingModelProvider
extends ValidatingModelProvider {
    private static final Logger log = LoggerFactory.getLogger(SkolemizingModelProvider.class);
    @Context
    private Request request;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model process(Model model) {
        if (this.getRequest().getMethod().equalsIgnoreCase("POST")) {
            try (ResIterator it = model.listSubjects();){
                while (it.hasNext()) {
                    Resource resource = (Resource)it.next();
                    this.process(resource);
                }
            }
            return this.skolemize(this.getOntology(), this.getUriInfo().getBaseUriBuilder(), this.getUriInfo().getAbsolutePathBuilder(), super.process(model));
        }
        return super.process(model);
    }

    public Resource process(Resource resource) {
        return resource;
    }

    public Model skolemize(Ontology ontology, UriBuilder baseUriBuilder, UriBuilder absolutePathBuilder, Model model) {
        try {
            return new Skolemizer(ontology, baseUriBuilder, absolutePathBuilder).build(model);
        }
        catch (IllegalArgumentException ex) {
            throw new SkolemizationException(ex, model);
        }
    }

    public Request getRequest() {
        return this.request;
    }
}

