/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.io;

import com.atomgraph.core.io.DatasetProvider;
import com.atomgraph.processor.util.Validator;
import com.atomgraph.server.exception.ConstraintViolationException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Providers;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.Dataset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.spinrdf.constraints.ConstraintViolation;

public class ValidatingDatasetProvider
extends DatasetProvider {
    private static final Logger log = LoggerFactory.getLogger(ValidatingDatasetProvider.class);
    @Context
    private Providers providers;

    public Dataset readFrom(Class<Dataset> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException {
        return this.process(super.readFrom(type, genericType, annotations, mediaType, httpHeaders, entityStream));
    }

    public Dataset process(Dataset dataset) {
        return this.validate(dataset);
    }

    public Dataset validate(Dataset dataset) {
        Validator validator = new Validator(this.getOntology().getOntModel());
        List<ConstraintViolation> cvs = validator.validate(dataset.getDefaultModel());
        if (!cvs.isEmpty()) {
            if (log.isDebugEnabled()) {
                log.debug("SPIN constraint violations: {}", cvs);
            }
            throw new ConstraintViolationException(cvs, dataset.getDefaultModel());
        }
        Iterator it = dataset.listNames();
        while (it.hasNext()) {
            String graphURI = (String)it.next();
            cvs = validator.validate(dataset.getNamedModel(graphURI));
            if (cvs.isEmpty()) continue;
            if (log.isDebugEnabled()) {
                log.debug("SPIN constraint violations: {}", cvs);
            }
            throw new ConstraintViolationException(cvs, dataset.getNamedModel(graphURI), graphURI);
        }
        return dataset;
    }

    public Ontology getOntology() {
        ContextResolver cr = this.getProviders().getContextResolver(Ontology.class, null);
        return (Ontology)cr.getContext(Ontology.class);
    }

    public Providers getProviders() {
        return this.providers;
    }
}

