/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.provider;

import com.atomgraph.processor.model.Template;
import com.atomgraph.processor.util.TemplateCall;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.PerRequestTypeInjectableProvider;
import java.net.URI;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.jena.rdf.model.ModelFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class TemplateCallProvider
extends PerRequestTypeInjectableProvider<Context, TemplateCall>
implements ContextResolver<TemplateCall> {
    private static final Logger log = LoggerFactory.getLogger(TemplateCallProvider.class);
    @Context
    Providers providers;
    @Context
    UriInfo uriInfo;

    public TemplateCallProvider() {
        super(TemplateCall.class);
    }

    public Injectable<TemplateCall> getInjectable(ComponentContext ic, Context a) {
        return new Injectable<TemplateCall>(){

            public TemplateCall getValue() {
                return TemplateCallProvider.this.getTemplateCall();
            }
        };
    }

    public TemplateCall getContext(Class<?> type) {
        return this.getTemplateCall();
    }

    public TemplateCall getTemplateCall() {
        if (this.getTemplate() != null) {
            return this.getTemplateCall(this.getTemplate(), this.getUriInfo().getAbsolutePath(), (MultivaluedMap<String, String>)this.getUriInfo().getQueryParameters());
        }
        return null;
    }

    public TemplateCall getTemplateCall(Template template, URI absolutePath, MultivaluedMap<String, String> queryParams) {
        if (template == null) {
            throw new IllegalArgumentException("Template cannot be null");
        }
        if (absolutePath == null) {
            throw new IllegalArgumentException("URI cannot be null");
        }
        if (queryParams == null) {
            throw new IllegalArgumentException("MultivaluedMap cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("Building TemplateCall from Template {}", (Object)template);
        }
        TemplateCall templateCall = TemplateCall.fromUri(absolutePath.toString(), ModelFactory.createDefaultModel(), template).applyArguments(queryParams).applyDefaults().validateOptionals();
        templateCall.build();
        return templateCall;
    }

    public Template getTemplate() {
        return (Template)this.getProviders().getContextResolver(Template.class, null).getContext(Template.class);
    }

    public Providers getProviders() {
        return this.providers;
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }
}

