/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.provider;

import com.atomgraph.processor.model.Template;
import com.atomgraph.processor.util.TemplateMatcher;
import com.sun.jersey.core.spi.component.ComponentContext;
import com.sun.jersey.spi.inject.Injectable;
import com.sun.jersey.spi.inject.PerRequestTypeInjectableProvider;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import org.apache.jena.ontology.Ontology;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class TemplateProvider
extends PerRequestTypeInjectableProvider<Context, Template>
implements ContextResolver<Template> {
    private static final Logger log = LoggerFactory.getLogger(TemplateProvider.class);
    @Context
    UriInfo uriInfo;
    @Context
    Providers providers;

    public TemplateProvider() {
        super(Template.class);
    }

    public Injectable<Template> getInjectable(ComponentContext ic, Context a) {
        return new Injectable<Template>(){

            public Template getValue() {
                return TemplateProvider.this.getTemplate();
            }
        };
    }

    public Template getContext(Class<?> type) {
        return this.getTemplate();
    }

    public Template getTemplate() {
        if (this.getOntology() != null) {
            return this.getTemplate(this.getOntology(), this.getUriInfo());
        }
        return null;
    }

    public Template getTemplate(Ontology ontology, UriInfo uriInfo) {
        return new TemplateMatcher(ontology).match(uriInfo.getAbsolutePath(), uriInfo.getBaseUri());
    }

    public UriInfo getUriInfo() {
        return this.uriInfo;
    }

    public Ontology getOntology() {
        return (Ontology)this.getProviders().getContextResolver(Ontology.class, null).getContext(Ontology.class);
    }

    public Providers getProviders() {
        return this.providers;
    }
}

