/*
 * Decompiled with CFR 0.152.
 */
package com.atomgraph.server.resource.graph;

import com.atomgraph.core.MediaTypes;
import com.atomgraph.core.model.Service;
import com.atomgraph.core.util.ModelUtils;
import com.atomgraph.processor.model.Application;
import com.atomgraph.processor.util.TemplateCall;
import com.atomgraph.server.model.impl.ResourceBase;
import com.sun.jersey.api.core.ResourceContext;
import java.net.URI;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.jena.ontology.Ontology;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.rdf.model.Model;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Item
extends ResourceBase {
    private static final Logger log = LoggerFactory.getLogger(Item.class);

    public Item(@Context UriInfo uriInfo, @Context Request request, @Context MediaTypes mediaTypes, @Context Service service, @Context Application application, @Context Ontology ontology, @Context TemplateCall templateCall, @Context HttpHeaders httpHeaders, @Context ResourceContext resourceContext) {
        super(uriInfo, request, mediaTypes, service, application, ontology, templateCall, httpHeaders, resourceContext);
        if (log.isDebugEnabled()) {
            log.debug("Constructing {} as direct indication of GRAPH {}", this.getClass(), (Object)uriInfo.getAbsolutePath());
        }
    }

    public Response get() {
        if (log.isDebugEnabled()) {
            log.debug("GET GRAPH {} from GraphStore {}", (Object)this.getURI());
        }
        return this.getResponse(DatasetFactory.create((Model)this.getService().getDatasetAccessor().getModel(this.getURI().toString())));
    }

    @Override
    public Response post(Dataset dataset) {
        if (log.isDebugEnabled()) {
            log.debug("POST GRAPH {} to GraphStore {}", (Object)this.getURI());
        }
        Dataset newDataset = DatasetFactory.create();
        newDataset.addNamedModel(this.getURI().toString(), dataset.getDefaultModel());
        return super.post(newDataset);
    }

    @Override
    public Response put(Dataset dataset) {
        Model existing = this.getService().getDatasetAccessor().getModel(this.getURI().toString());
        if (!existing.isEmpty()) {
            EntityTag entityTag = new EntityTag(Long.toHexString(ModelUtils.hashModel((Model)dataset.getDefaultModel())));
            Response.ResponseBuilder rb = this.getRequest().evaluatePreconditions(entityTag);
            if (rb != null) {
                if (log.isDebugEnabled()) {
                    log.debug("PUT preconditions were not met for resource: {} with entity tag: {}", (Object)this, (Object)entityTag);
                }
                return rb.build();
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("PUT GRAPH {} to GraphStore", (Object)this.getURI());
        }
        this.getService().getDatasetAccessor().putModel(this.getURI().toString(), dataset.getDefaultModel());
        if (existing.isEmpty()) {
            return Response.created((URI)this.getURI()).build();
        }
        return Response.ok((Object)dataset).build();
    }

    @Override
    public Response delete() {
        if (log.isDebugEnabled()) {
            log.debug("DELETE GRAPH {} from GraphStore", (Object)this.getURI());
        }
        this.getService().getDatasetAccessor().deleteModel(this.getURI().toString());
        return Response.noContent().build();
    }
}

