/*
 * Decompiled with CFR 0.152.
 */
package com.authkit;

import com.authkit.Authenticator;
import com.authkit.AuthkitException;
import com.authkit.AuthkitPrincipal;
import com.authkit.Config;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.google.gson.FieldNamingPolicy;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.reactivestreams.Publisher;
import reactor.cache.CacheMono;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Signal;
import reactor.netty.http.client.HttpClient;

public class DefaultAuthenticator
implements Authenticator {
    private static final Gson GSON = new GsonBuilder().setFieldNamingPolicy(FieldNamingPolicy.LOWER_CASE_WITH_UNDERSCORES).create();
    private static final Set<String> RESERVED_CLAIMS = new HashSet<String>();
    private static final String CLAIM_SUB = "sub";
    private static final String CLAIM_EMAIL = "email";
    private static final String CLAIM_EMAIL_VERIFIED = "email_verified";
    private static final String CLAIM_FAMILY_NAME = "family_name";
    private static final String CLAIM_GENDER = "gender";
    private static final String CLAIM_GIVEN_NAME = "given_name";
    private static final String CLAIM_GROUPS = "groups";
    private static final String CLAIM_MIDDLE_NAME = "middle_name";
    private static final String CLAIM_NAME = "name";
    private static final String CLAIM_NICKNAME = "nickname";
    private static final String CLAIM_PERMISSIONS = "permissions";
    private static final String CLAIM_PHONE_NUMBER = "phone_number";
    private static final String CLAIM_PHONE_NUMBER_VERIFIED = "phone_number_verified";
    private static final String CLAIM_PREFERRED_USERNAME = "preferred_username";
    private static final String CLAIM_ROLES = "roles";
    private static final String CLAIM_UPDATED_AT = "updated_at";
    private static final String CLAIM_METADATA = "metadata";
    private final String issuer;
    private final String audience;
    private final HttpClient client;
    private final Cache<String, AuthkitPrincipal> principalCache = Caffeine.newBuilder().maximumSize(10000L).expireAfterWrite(Duration.ofMinutes(120L)).build();
    private final Cache<String, ParserAndUserinfoEndpoint> keyIdAndUserinfoCache = Caffeine.newBuilder().maximumSize(100L).expireAfterWrite(Duration.ofMinutes(120L)).build();

    public DefaultAuthenticator(Config config) {
        this.issuer = config.getIssuer();
        this.audience = config.getAudience();
        this.client = HttpClient.create();
    }

    private Mono<ParserAndUserinfoEndpoint> getParserAndUserinfo(String keyId) {
        return CacheMono.lookup(k -> Mono.justOrEmpty((Object)((ParserAndUserinfoEndpoint)this.keyIdAndUserinfoCache.getIfPresent(k))).map(Signal::next), (Object)keyId).onCacheMissResume(Mono.from(this.doGetParserAndUserinfo(keyId))).andWriteWith((k, u) -> Mono.fromRunnable(() -> {
            if (u.hasValue()) {
                this.keyIdAndUserinfoCache.put(k, (Object)((ParserAndUserinfoEndpoint)u.get()));
            }
        }));
    }

    private Mono<ParserAndUserinfoEndpoint> doGetParserAndUserinfo(String keyId) {
        return ((HttpClient.ResponseReceiver)this.client.get().uri(this.issuer + "/.well-known/openid-configuration")).responseSingle((r, b) -> {
            if (r.status().code() == 200) {
                return b.asInputStream();
            }
            throw new AuthkitException("unable to load openid-configuration, code: " + r.status().code());
        }).map(i -> (OpenIdConfiguration)GSON.fromJson((Reader)new InputStreamReader((InputStream)i), OpenIdConfiguration.class)).flatMap(oidc -> ((HttpClient.ResponseReceiver)this.client.get().uri(oidc.jwksUri)).responseSingle((r, b) -> {
            if (r.status().code() == 200) {
                return b.asInputStream().map(i -> new Tuple<InputStream, String>((InputStream)i, oidc.userinfoEndpoint));
            }
            throw new AuthkitException("unable to load jwks, code: " + r.status().code());
        }).map(i -> new Tuple<Jwks, String>((Jwks)GSON.fromJson((Reader)new InputStreamReader((InputStream)i.value1), Jwks.class), (String)i.value2))).map(j -> {
            try {
                String input = ((Jwks)j.value1).keys[0].x5c[0];
                byte[] inputBytes = Base64.getDecoder().decode(input);
                CertificateFactory fact = CertificateFactory.getInstance("X.509");
                ByteArrayInputStream is = new ByteArrayInputStream(inputBytes);
                X509Certificate cer = (X509Certificate)fact.generateCertificate(is);
                return new Tuple<PublicKey, String>(cer.getPublicKey(), (String)j.value2);
            }
            catch (Exception e) {
                throw new AuthkitException(e);
            }
        }).map(pk -> {
            JwtParserBuilder builder = Jwts.parserBuilder().setSigningKey((java.security.Key)pk.value1).requireIssuer(this.issuer);
            return new ParserAndUserinfoEndpoint(builder.build(), (String)pk.value2);
        });
    }

    @Override
    public Publisher<AuthkitPrincipal> authenticate(String token) {
        return CacheMono.lookup(k -> Mono.justOrEmpty((Object)((AuthkitPrincipal)this.principalCache.getIfPresent(k))).map(Signal::next), (Object)token).onCacheMissResume(Mono.from(this.doAuthenticate(token))).andWriteWith((k, u) -> Mono.fromRunnable(() -> {
            if (u.hasValue()) {
                this.principalCache.put(k, (Object)((AuthkitPrincipal)u.get()));
            }
        }));
    }

    private String validateAndGetKeyId(String token) {
        String[] parts = token.split("\\.", 3);
        if (parts.length != 3) {
            throw new AuthkitException("invalid jwt");
        }
        String headerString = new String(Base64.getDecoder().decode(parts[0]));
        MinimalHeader header = (MinimalHeader)GSON.fromJson(headerString, MinimalHeader.class);
        String bodyString = new String(Base64.getDecoder().decode(parts[1]));
        MinimalBody body = (MinimalBody)GSON.fromJson(bodyString, MinimalBody.class);
        if (!this.issuer.equals(body.iss)) {
            throw new AuthkitException("invalid issuer");
        }
        if (this.audience != null && !this.audience.equals(body.aud)) {
            throw new AuthkitException("invalid audience");
        }
        if (header.kid == null) {
            throw new AuthkitException("header missing kid");
        }
        return header.kid;
    }

    public Publisher<AuthkitPrincipal> doAuthenticate(String token) {
        return Mono.fromCallable(() -> this.validateAndGetKeyId(token)).flatMap(this::getParserAndUserinfo).map(j -> {
            Jws jws = j.parser.parseClaimsJws(token);
            Claims claims = (Claims)jws.getBody();
            AuthkitPrincipal p = new AuthkitPrincipal();
            p.setIssuer(claims.getIssuer());
            p.setSub(claims.getSubject());
            p.setAudience(claims.getAudience());
            p.setPermissions(DefaultAuthenticator.orDefaultSet(claims.get((Object)CLAIM_PERMISSIONS)));
            p.setRoles(DefaultAuthenticator.orDefaultSet(claims.get((Object)CLAIM_ROLES)));
            p.setGroups(DefaultAuthenticator.orDefaultSet(claims.get((Object)CLAIM_GROUPS)));
            return new Tuple<AuthkitPrincipal, String>(p, j.userinfoEndpoint);
        }).flatMap(t -> ((HttpClient.ResponseReceiver)this.client.headers(h -> h.add("Authorization", (Object)("Bearer " + token))).get().uri((String)t.value2)).responseSingle((r, b) -> {
            if (r.status().code() == 200) {
                return b.asInputStream().map(i -> new Tuple<InputStream, AuthkitPrincipal>((InputStream)i, (AuthkitPrincipal)t.value1));
            }
            throw new AuthkitException("unable to load userinfo, code: " + r.status().code());
        })).map(t -> {
            HashMap userinfo = (HashMap)GSON.fromJson((Reader)new InputStreamReader((InputStream)t.value1), HashMap.class);
            AuthkitPrincipal p = (AuthkitPrincipal)t.value2;
            if (userinfo != null) {
                p.setEmail((String)userinfo.get(CLAIM_EMAIL));
                p.setEmailVerified((Boolean)userinfo.get(CLAIM_EMAIL_VERIFIED));
                p.setFamilyName((String)userinfo.get(CLAIM_FAMILY_NAME));
                p.setGender((String)userinfo.get(CLAIM_GENDER));
                p.setGivenName((String)userinfo.get(CLAIM_GIVEN_NAME));
                p.setMiddleName((String)userinfo.get(CLAIM_MIDDLE_NAME));
                p.setClaimName((String)userinfo.get(CLAIM_NAME));
                p.setNickname((String)userinfo.get(CLAIM_NICKNAME));
                p.setPhoneNumber((String)userinfo.get(CLAIM_PHONE_NUMBER));
                p.setPhoneNumberVerified((Boolean)userinfo.get(CLAIM_PHONE_NUMBER_VERIFIED));
                p.setPreferredUsername((String)userinfo.get(CLAIM_PREFERRED_USERNAME));
                p.setUpdatedAt(DefaultAuthenticator.toLong((Double)userinfo.get(CLAIM_UPDATED_AT)));
                p.setMetadata(this.orDefaultMap(userinfo.get(CLAIM_METADATA)));
                if (p.getPermissions().isEmpty()) {
                    p.setPermissions(DefaultAuthenticator.orDefaultSet(userinfo.get(CLAIM_PERMISSIONS)));
                }
                if (p.getGroups().isEmpty()) {
                    p.setGroups(DefaultAuthenticator.orDefaultSet(userinfo.get(CLAIM_GROUPS)));
                }
                if (p.getRoles().isEmpty()) {
                    p.setRoles(DefaultAuthenticator.orDefaultSet(userinfo.get(CLAIM_ROLES)));
                }
                userinfo.forEach((k, v) -> {
                    String key = (String)k;
                    if (!RESERVED_CLAIMS.contains(k)) {
                        p.getExtraClaims().put(key, v);
                    }
                });
            }
            return p;
        });
    }

    private static Long toLong(Double input) {
        if (input == null) {
            return null;
        }
        return input.longValue();
    }

    private static Set<String> stringArrayToStringSetClaim(Claims claims, String name) {
        ArrayList raw = (ArrayList)claims.get(name, ArrayList.class);
        if (raw == null) {
            return new HashSet<String>();
        }
        return new HashSet<String>(raw);
    }

    private static Set<String> orDefaultSet(Object input) {
        if (input != null) {
            HashSet<String> result = new HashSet<String>();
            for (String el : (List)input) {
                result.add(el);
            }
            return result;
        }
        return Set.of();
    }

    private Map<String, Object> orDefaultMap(Object input) {
        if (input != null) {
            return (Map)input;
        }
        return Map.of();
    }

    static {
        RESERVED_CLAIMS.add(CLAIM_SUB);
        RESERVED_CLAIMS.add(CLAIM_EMAIL);
        RESERVED_CLAIMS.add(CLAIM_EMAIL_VERIFIED);
        RESERVED_CLAIMS.add(CLAIM_FAMILY_NAME);
        RESERVED_CLAIMS.add(CLAIM_GENDER);
        RESERVED_CLAIMS.add(CLAIM_GIVEN_NAME);
        RESERVED_CLAIMS.add(CLAIM_GROUPS);
        RESERVED_CLAIMS.add(CLAIM_MIDDLE_NAME);
        RESERVED_CLAIMS.add(CLAIM_NAME);
        RESERVED_CLAIMS.add(CLAIM_NICKNAME);
        RESERVED_CLAIMS.add(CLAIM_PERMISSIONS);
        RESERVED_CLAIMS.add(CLAIM_PHONE_NUMBER);
        RESERVED_CLAIMS.add(CLAIM_PHONE_NUMBER_VERIFIED);
        RESERVED_CLAIMS.add(CLAIM_PREFERRED_USERNAME);
        RESERVED_CLAIMS.add(CLAIM_ROLES);
        RESERVED_CLAIMS.add(CLAIM_UPDATED_AT);
        RESERVED_CLAIMS.add(CLAIM_METADATA);
    }

    private static class Tuple<T1, T2> {
        private final T1 value1;
        private final T2 value2;

        private Tuple(T1 value1, T2 value2) {
            this.value1 = value1;
            this.value2 = value2;
        }
    }

    private static class ParserAndUserinfoEndpoint {
        private final JwtParser parser;
        private final String userinfoEndpoint;

        private ParserAndUserinfoEndpoint(JwtParser parser, String userinfoEndpoint) {
            this.parser = parser;
            this.userinfoEndpoint = userinfoEndpoint;
        }
    }

    public static class Key {
        private String alg;
        private String e;
        private String kid;
        private String kty;
        private String n;
        private String use;
        private String[] x5c;
        private String x5t;
    }

    public static class Jwks {
        private Key[] keys;
    }

    public static class OpenIdConfiguration {
        private String authorizationEndpoint;
        private String[] grantTypesSupported;
        private String[] idTokenSigningAlgValuesSupported;
        private String issuer;
        private String jwksUri;
        private String[] responseModesSupported;
        private String[] responseTypesSupported;
        private String revocationEndpoint;
        private String[] subjectTypesSupported;
        private String tokenEndpoint;
        private String userinfoEndpoint;
    }

    private static class MinimalBody {
        private String iss;
        private String aud;

        private MinimalBody() {
        }
    }

    private static class MinimalHeader {
        private String kid;

        private MinimalHeader() {
        }
    }
}

