/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.cache;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;

public class CachedSupplier<T>
implements Supplier<T> {
    private final Supplier<T> delegate;
    private final AtomicReference<Optional<T>> value = new AtomicReference();

    @Override
    public T get() {
        Optional<Object> cached = this.value.get();
        if (cached == null) {
            T v = this.delegate.get();
            this.value.set(Optional.ofNullable(v));
            return v;
        }
        return cached.orElse(null);
    }

    public CachedSupplier(Supplier<T> delegate) {
        this.delegate = delegate;
    }
}

