/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.rxjava3;

import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Single;
import java.util.concurrent.CompletionStage;

public class Rx3Util {
    private Rx3Util() {
    }

    public static <T> Single<T> toSingle(CompletionStage<T> future) {
        return Single.create(subscriber -> future.thenAccept(result -> subscriber.onSuccess(result)).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static <T> Maybe<T> toMaybe(CompletionStage<T> future) {
        return Maybe.create(subscriber -> future.thenAccept(result -> {
            if (result == null) {
                subscriber.onComplete();
            } else {
                subscriber.onSuccess(result);
            }
        }).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static Completable toCompletable(CompletionStage<Void> future) {
        return Completable.create(subscriber -> future.thenAccept(ignore -> subscriber.onComplete()).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }
}

