/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.rxjava3;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.ObservableSource;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import java.util.concurrent.CompletionStage;

public class Rx3Util {
    private Rx3Util() {
    }

    public static <T> Single<T> toSingle(CompletionStage<T> future) {
        return Single.create(subscriber -> future.thenAccept(result -> subscriber.onSuccess(result)).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static <T> Maybe<T> toMaybe(CompletionStage<T> future) {
        return Maybe.create(subscriber -> future.thenAccept(result -> {
            if (result == null) {
                subscriber.onComplete();
            } else {
                subscriber.onSuccess(result);
            }
        }).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static Completable toCompletable(CompletionStage<Void> future) {
        return Completable.create(subscriber -> future.thenAccept(ignore -> subscriber.onComplete()).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static <U, D> ObservableTransformer<U, D> wrapTransformerErrors(String message, ObservableTransformer<U, D> transformer) {
        return new ErrorWrapObservableTransformer<U, D>(message, transformer);
    }

    private static final class ErrorWrapObservableTransformer<U, D>
    implements ObservableTransformer<U, D> {
        private final String message;
        private final ObservableTransformer<U, D> transformer;
        private boolean upstreamError = false;

        @NonNull
        public ObservableSource<D> apply(@NonNull Observable<U> upstream) {
            return upstream.doOnError(e -> {
                this.upstreamError = true;
            }).compose(this.transformer).onErrorResumeNext(e -> {
                if (!this.upstreamError) {
                    return Observable.error((Throwable)new RuntimeException(this.message, (Throwable)e));
                }
                return Observable.error((Throwable)e);
            });
        }

        private ErrorWrapObservableTransformer(String message, ObservableTransformer<U, D> transformer) {
            this.message = message;
            this.transformer = transformer;
        }
    }
}

