/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.rxjava3;

import com.autonomouslogic.commons.rxjava3.internal.ErrorWrapObservableTransformer;
import com.autonomouslogic.commons.rxjava3.internal.OrderedMerger;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import java.util.Comparator;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public class Rx3Util {
    private Rx3Util() {
    }

    public static <T> Single<T> toSingle(CompletionStage<T> future) {
        return Single.create(subscriber -> future.thenAccept(result -> subscriber.onSuccess(result)).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static <T> Maybe<T> toMaybe(CompletionStage<T> future) {
        return Maybe.create(subscriber -> future.thenAccept(result -> {
            if (result == null) {
                subscriber.onComplete();
            } else {
                subscriber.onSuccess(result);
            }
        }).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static Completable toCompletable(CompletionStage<Void> future) {
        return Completable.create(subscriber -> future.thenAccept(ignore -> subscriber.onComplete()).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static <U, D> ObservableTransformer<U, D> wrapTransformerErrors(String message, ObservableTransformer<U, D> transformer) {
        return new ErrorWrapObservableTransformer<U, D>(message, transformer);
    }

    public static <T> Publisher<T> orderedMerge(Comparator<T> comparator, Publisher<T> ... sources) {
        return new OrderedMerger<T>(comparator, sources).createPublisher();
    }
}

