/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.rxjava3;

import com.autonomouslogic.commons.rxjava3.internal.ErrorWrapObservableTransformer;
import com.autonomouslogic.commons.rxjava3.internal.OrderedMerger;
import com.autonomouslogic.commons.rxjava3.internal.ZipAll;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import java.util.Comparator;
import java.util.concurrent.CompletionStage;
import org.reactivestreams.Publisher;

public class Rx3Util {
    private Rx3Util() {
    }

    public static <T> Single<T> toSingle(CompletionStage<T> future) {
        return Single.create(subscriber -> future.thenAccept(result -> subscriber.onSuccess(result)).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static <T> Maybe<T> toMaybe(CompletionStage<T> future) {
        return Maybe.create(subscriber -> future.thenAccept(result -> {
            if (result == null) {
                subscriber.onComplete();
            } else {
                subscriber.onSuccess(result);
            }
        }).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static Completable toCompletable(CompletionStage<Void> future) {
        return Completable.create(subscriber -> future.thenAccept(ignore -> subscriber.onComplete()).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static <U, D> ObservableTransformer<U, D> wrapTransformerErrors(String message, ObservableTransformer<U, D> transformer) {
        return new ErrorWrapObservableTransformer<U, D>(message, transformer);
    }

    public static <T> Publisher<T> orderedMerge(Comparator<T> comparator, Publisher<T> ... sources) {
        return new OrderedMerger<T>(comparator, sources).createPublisher();
    }

    public static <T, R> Flowable<R> zipAllFlowable(@NonNull Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize, Publisher<? extends T> ... sources) {
        return new ZipAll(zipper, delayError, bufferSize, sources).createFlowable();
    }

    public static <T, R> Flowable<R> zipAllFlowable(@NonNull Function<? super Object[], ? extends R> zipper, Publisher<? extends T> ... sources) {
        return Rx3Util.zipAllFlowable(zipper, false, Flowable.bufferSize(), sources);
    }
}

