/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.rxjava3;

import com.autonomouslogic.commons.rxjava3.WindowSort;
import com.autonomouslogic.commons.rxjava3.internal.CheckOrder;
import com.autonomouslogic.commons.rxjava3.internal.ErrorWrapObservableTransformer;
import com.autonomouslogic.commons.rxjava3.internal.OrderedMerger;
import com.autonomouslogic.commons.rxjava3.internal.ZipAll;
import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Completable;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import io.reactivex.rxjava3.core.Maybe;
import io.reactivex.rxjava3.core.ObservableTransformer;
import io.reactivex.rxjava3.core.Single;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Predicate;
import java.time.Duration;
import java.util.Comparator;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;

public class Rx3Util {
    private Rx3Util() {
    }

    public static <T> Single<T> toSingle(CompletionStage<T> future) {
        return Single.create(subscriber -> future.thenAccept(result -> subscriber.onSuccess(result)).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static <T> Maybe<T> toMaybe(CompletionStage<T> future) {
        return Maybe.create(subscriber -> future.thenAccept(result -> {
            if (result == null) {
                subscriber.onComplete();
            } else {
                subscriber.onSuccess(result);
            }
        }).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static Completable toCompletable(CompletionStage<Void> future) {
        return Completable.create(subscriber -> future.thenAccept(ignore -> subscriber.onComplete()).exceptionally(e -> {
            subscriber.onError(e);
            return null;
        }));
    }

    public static <U, D> ObservableTransformer<U, D> wrapTransformerErrors(String message, ObservableTransformer<U, D> transformer) {
        return new ErrorWrapObservableTransformer<U, D>(message, transformer);
    }

    public static <T> Publisher<T> orderedMerge(Comparator<T> comparator, Publisher<T> ... sources) {
        return new OrderedMerger<T>(comparator, sources).createPublisher();
    }

    public static <T, R> Flowable<R> zipAllFlowable(@NonNull Function<? super Object[], ? extends R> zipper, boolean delayError, int bufferSize, Publisher<? extends T> ... sources) {
        return new ZipAll(zipper, delayError, bufferSize, sources).createFlowable();
    }

    public static <T, R> Flowable<R> zipAllFlowable(@NonNull Function<? super Object[], ? extends R> zipper, Publisher<? extends T> ... sources) {
        return Rx3Util.zipAllFlowable(zipper, false, Flowable.bufferSize(), sources);
    }

    public static <T> WindowSort<T> windowSort(Comparator<T> comparator, int minWindowSize) {
        return new WindowSort<T>(comparator, minWindowSize);
    }

    public static <T> CheckOrder<T> checkOrder(Comparator<T> comparator) {
        return new CheckOrder<T>(comparator);
    }

    public static <T> FlowableTransformer<T, T> retryWithDelayFlowable(int times, Duration delay) {
        return Rx3Util.retryWithDelayFlowable(times, delay, (Predicate<? super Throwable>)((Predicate)e -> true));
    }

    public static <T> FlowableTransformer<T, T> retryWithDelayFlowable(int times, Duration delay, Predicate<? super Throwable> predicate) {
        if (times < 0) {
            throw new IllegalArgumentException("times >= 0 required but it was " + times);
        }
        long delayNs = delay.toNanos();
        if (delayNs < 0L) {
            throw new IllegalArgumentException("delay must be zero or more");
        }
        return upstream -> upstream.retryWhen(e -> {
            AtomicInteger t = new AtomicInteger();
            return e.flatMap(err -> {
                int i = t.incrementAndGet();
                if (i <= times && predicate.test(err)) {
                    return Flowable.timer((long)delayNs, (TimeUnit)TimeUnit.NANOSECONDS);
                }
                return Flowable.error((Throwable)err);
            });
        });
    }
}

