/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons;

import java.time.Duration;

public class Stopwatch {
    private long start;
    private long nanos = 0L;
    private boolean running = true;

    private Stopwatch(long start) {
        this.start = start;
    }

    public static Stopwatch start() {
        return new Stopwatch(System.nanoTime());
    }

    public void restart() {
        long now = System.nanoTime();
        if (this.running) {
            return;
        }
        this.start = now;
        this.running = true;
    }

    public void stop() {
        long now = System.nanoTime();
        if (!this.running) {
            return;
        }
        this.nanos += now - this.start;
        this.running = false;
    }

    public Duration getDuration() {
        return Duration.ofNanos(this.nanos);
    }

    public long getNanos() {
        return this.nanos;
    }
}

