/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.config;

import com.autonomouslogic.commons.config.ConfigParser;
import com.autonomouslogic.commons.config.DefaultConfigParsers;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import lombok.NonNull;

public class Config<T> {
    @NonNull
    String name;
    @NonNull
    Class<T> type;
    ConfigParser<T> parser;
    T defaultValue;
    Supplier<Optional<T>> defaultMethod;

    public Optional<T> get() {
        return this.getSetValue().or(this::getDefaultValue);
    }

    public T getRequired() {
        return this.get().orElseThrow(() -> new IllegalArgumentException(String.format("No value for %s", this.name)));
    }

    private Optional<T> getSetValue() {
        String fileName = this.name + "_FILE";
        Map<String, String> env = System.getenv();
        if (env.containsKey(this.name) && env.containsKey(fileName)) {
            throw new IllegalArgumentException(String.format("Both %s and %s cannot be set at the same time", this.name, fileName));
        }
        if (!env.containsKey(this.name) && !env.containsKey(fileName)) {
            return Optional.empty();
        }
        return this.getFromEnv(this.name).or(() -> this.getFromFile(fileName));
    }

    private Optional<T> getFromEnv(String env) {
        String value = System.getenv(env);
        if (value == null || value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.parse(env, value));
    }

    private Optional<T> getFromFile(String env) {
        String filename = System.getenv(env);
        if (filename == null || filename.isEmpty()) {
            return Optional.empty();
        }
        File file = new File(filename);
        if (!file.exists()) {
            throw new FileNotFoundException(filename);
        }
        String value = this.readFile(file);
        if (value.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(this.parse(env, value));
    }

    private String readFile(File file) {
        StringBuilder builder = new StringBuilder();
        char[] buffer = new char[1024];
        try (FileReader reader = new FileReader(file, StandardCharsets.UTF_8);){
            int n;
            while (-1 != (n = reader.read(buffer))) {
                builder.append(buffer, 0, n);
            }
        }
        return builder.toString().trim();
    }

    private T parse(String env, String value) {
        try {
            return this.getParser(env).parse(value);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Unable to parse value in %s as type %s", env, this.type));
        }
    }

    private ConfigParser<T> getParser(String env) {
        return Optional.ofNullable(this.parser).or(() -> DefaultConfigParsers.getParser(this.type)).orElseThrow(() -> new IllegalArgumentException(String.format("Unsupported type %s for %s", this.type, env)));
    }

    private Optional<T> getDefaultValue() {
        if (this.defaultValue != null && this.defaultMethod != null) {
            throw new IllegalArgumentException(String.format("Both default value and default method specified for %s", this.name));
        }
        if (this.defaultValue != null) {
            return Optional.of(this.defaultValue);
        }
        if (this.defaultMethod != null) {
            return this.defaultMethod.get();
        }
        return Optional.empty();
    }

    public String toString() {
        return "Config{name='" + this.name + "'}";
    }

    Config(@NonNull String name, @NonNull Class<T> type, ConfigParser<T> parser, T defaultValue, Supplier<Optional<T>> defaultMethod) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.name = name;
        this.type = type;
        this.parser = parser;
        this.defaultValue = defaultValue;
        this.defaultMethod = defaultMethod;
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    public static class Builder<T> {
        private String name;
        private Class<T> type;
        private ConfigParser<T> parser;
        private T defaultValue;
        private Supplier<Optional<T>> defaultMethod;

        Builder() {
        }

        public Builder<T> name(@NonNull String name) {
            if (name == null) {
                throw new NullPointerException("name is marked non-null but is null");
            }
            this.name = name;
            return this;
        }

        public Builder<T> type(@NonNull Class<T> type) {
            if (type == null) {
                throw new NullPointerException("type is marked non-null but is null");
            }
            this.type = type;
            return this;
        }

        public Builder<T> parser(ConfigParser<T> parser) {
            this.parser = parser;
            return this;
        }

        public Builder<T> defaultValue(T defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder<T> defaultMethod(Supplier<Optional<T>> defaultMethod) {
            this.defaultMethod = defaultMethod;
            return this;
        }

        public Config<T> build() {
            return new Config<T>(this.name, this.type, this.parser, this.defaultValue, this.defaultMethod);
        }

        public String toString() {
            return "Config.Builder(name=" + this.name + ", type=" + this.type + ", parser=" + this.parser + ", defaultValue=" + this.defaultValue + ", defaultMethod=" + this.defaultMethod + ")";
        }
    }
}

