/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.config;

import com.autonomouslogic.commons.config.ConfigParser;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.Duration;
import java.time.LocalDate;
import java.time.Period;
import java.util.Optional;

public final class DefaultConfigParsers {
    public static <T> Optional<ConfigParser<T>> getParser(Class<T> type) {
        if (type == String.class) {
            return Optional.of(type::cast);
        }
        if (type == Integer.class) {
            return Optional.of(value -> type.cast(Integer.parseInt(value)));
        }
        if (type == Long.class) {
            return Optional.of(value -> type.cast(Long.parseLong(value)));
        }
        if (type == Float.class) {
            return Optional.of(value -> type.cast(Float.valueOf(Float.parseFloat(value))));
        }
        if (type == Double.class) {
            return Optional.of(value -> type.cast(Double.parseDouble(value)));
        }
        if (type == BigInteger.class) {
            return Optional.of(value -> type.cast(new BigInteger(value)));
        }
        if (type == BigDecimal.class) {
            return Optional.of(value -> type.cast(new BigDecimal(value)));
        }
        if (type == Boolean.class) {
            return Optional.of(value -> type.cast(Boolean.parseBoolean(value)));
        }
        if (type == LocalDate.class) {
            return Optional.of(value -> type.cast(LocalDate.parse(value)));
        }
        if (type == Duration.class) {
            return Optional.of(value -> type.cast(Duration.parse(value)));
        }
        if (type == Period.class) {
            return Optional.of(value -> type.cast(Period.parse(value)));
        }
        if (type == URI.class) {
            return Optional.of(value -> type.cast(new URI(value)));
        }
        return Optional.empty();
    }

    private DefaultConfigParsers() {
    }
}

