/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.rxjava3.internal;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Emitter;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.reactivestreams.Publisher;

public class OrderedMerger<T> {
    @NonNull
    private final Comparator<T> comparator;
    @NonNull
    private final Publisher<T>[] sources;

    public Publisher<T> createPublisher() {
        if (this.sources.length == 0) {
            return Flowable.empty();
        }
        return Flowable.generate(() -> new MergeState<T>(this.comparator, this.sources), (state, emitter) -> {
            state.next(emitter);
            return state;
        }, mergeState -> mergeState.dispose()).subscribeOn(Schedulers.io()).observeOn(Schedulers.computation());
    }

    @Generated
    public OrderedMerger(@NonNull Comparator<T> comparator, @NonNull Publisher<T>[] sources) {
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        if (sources == null) {
            throw new NullPointerException("sources is marked non-null but is null");
        }
        this.comparator = comparator;
        this.sources = sources;
    }

    private static class MergeState<P> {
        private final int n;
        private final Comparator<P> comparator;
        private final Iterator<P>[] iterators;
        private final Object[] current;
        private final List<Entry> entries;
        private final Comparator<Entry> entryComparator;

        MergeState(Comparator<P> comparator, Publisher<P>[] sources) {
            this.comparator = comparator;
            this.n = sources.length;
            this.iterators = new Iterator[this.n];
            this.entries = new ArrayList<Entry>(this.n);
            this.current = new Object[this.n];
            for (int i = 0; i < this.n; ++i) {
                this.iterators[i] = Flowable.fromPublisher(sources[i]).blockingIterable().iterator();
            }
            this.entryComparator = Comparator.comparing(entry -> entry.getObj(), comparator);
            this.fill();
        }

        private void fill() {
            boolean changed = false;
            for (int i = 0; i < this.n; ++i) {
                if (this.current[i] != null || !this.iterators[i].hasNext()) continue;
                this.current[i] = this.iterators[i].next();
                this.entries.add(new Entry(i, this.current[i]));
                changed = true;
            }
            if (changed) {
                this.entries.sort(this.entryComparator);
            }
        }

        private P remove(int i) {
            Object obj = this.current[i];
            this.current[i] = null;
            this.entries.remove(new Entry(i, null));
            return (P)obj;
        }

        private int nextIndex() {
            this.fill();
            if (this.entries.isEmpty()) {
                return -1;
            }
            return this.entries.get(0).getIndex();
        }

        protected void next(Emitter<P> emitter) {
            int i = this.nextIndex();
            if (i == -1) {
                emitter.onComplete();
            } else {
                emitter.onNext(this.remove(i));
            }
        }

        protected void dispose() {
        }
    }

    private static final class Entry {
        private final int index;
        private final Object obj;

        @Generated
        public Entry(int index, Object obj) {
            this.index = index;
            this.obj = obj;
        }

        @Generated
        public int getIndex() {
            return this.index;
        }

        @Generated
        public Object getObj() {
            return this.obj;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            return this.getIndex() == other.getIndex();
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getIndex();
            return result;
        }

        @Generated
        public String toString() {
            return "OrderedMerger.Entry(index=" + this.getIndex() + ", obj=" + String.valueOf(this.getObj()) + ")";
        }
    }
}

