/*
 * Decompiled with CFR 0.152.
 */
package com.autonomouslogic.commons.rxjava3;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableTransformer;
import java.util.ArrayList;
import java.util.Comparator;
import org.reactivestreams.Publisher;

public class WindowSort<T>
implements FlowableTransformer<T, T> {
    @lombok.NonNull
    private final Comparator<T> comparator;
    private final int minWindowSize;

    public WindowSort(@lombok.NonNull Comparator<T> comparator, int minWindowSize) {
        if (comparator == null) {
            throw new NullPointerException("comparator is marked non-null but is null");
        }
        if (minWindowSize < 1) {
            throw new IllegalArgumentException("minWindowSize must be at least 1");
        }
        this.comparator = comparator;
        this.minWindowSize = minWindowSize;
    }

    @NonNull
    public Publisher<T> apply(@NonNull Flowable<T> upstream) {
        return Flowable.defer(() -> {
            ArrayList window = new ArrayList(this.minWindowSize * 2);
            ArrayList tmp = new ArrayList(this.minWindowSize);
            Flowable sorted = upstream.buffer(this.minWindowSize).flatMap(buffer -> {
                window.addAll(buffer);
                window.sort(this.comparator);
                int len = window.size() - this.minWindowSize;
                if (len <= 0) {
                    return Flowable.empty();
                }
                ArrayList result = new ArrayList(window.subList(0, len));
                tmp.addAll(window.subList(len, window.size()));
                window.clear();
                window.addAll(tmp);
                tmp.clear();
                return Flowable.fromIterable(result);
            }, 1);
            Flowable remaining = Flowable.defer(() -> Flowable.fromIterable((Iterable)window));
            return Flowable.concat((Publisher)sorted, (Publisher)remaining);
        });
    }
}

