/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay;

import com.avsystem.anjay.AnjayObject;
import com.avsystem.anjay.AnjaySecurityConfigFromDm;
import com.avsystem.anjay.impl.NativeAnjay;
import com.avsystem.anjay.impl.NativeLog;
import java.nio.channels.SelectableChannel;
import java.time.Duration;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public final class Anjay
implements AutoCloseable {
    private NativeAnjay anjay;
    public static final int SSID_ANY = NativeAnjay.getSsidAny();
    public static final int SSID_BOOTSTRAP = NativeAnjay.getSsidBootstrap();
    public static final int ID_INVALID = NativeAnjay.getIdInvalid();

    public Anjay(Configuration config) {
        NativeLog.initialize();
        this.anjay = new NativeAnjay(config);
    }

    @Override
    public void close() {
        this.anjay.close();
    }

    public static String getVersion() {
        return NativeAnjay.getVersion();
    }

    public void schedRun() {
        this.anjay.schedRun();
    }

    public List<SelectableChannel> getSockets() {
        return this.getSocketEntries().stream().map(entry -> entry.channel).collect(Collectors.toList());
    }

    public List<SocketEntry> getSocketEntries() {
        return this.anjay.getSocketEntries();
    }

    public void serve(SelectableChannel channel) throws Exception {
        this.anjay.serve(channel);
    }

    public Optional<Duration> timeToNext() {
        return this.anjay.timeToNext();
    }

    public void scheduleRegistrationUpdate(int ssid) {
        this.anjay.scheduleRegistrationUpdate(ssid);
    }

    public void scheduleReconnect(Set<Transport> transportSet) {
        this.anjay.scheduleReconnect(transportSet);
    }

    public void scheduleReconnect() {
        this.scheduleReconnect(EnumSet.allOf(Transport.class));
    }

    public void disableServer(int ssid) {
        this.anjay.disableServer(ssid);
    }

    public void enableServer(int ssid) {
        this.anjay.enableServer(ssid);
    }

    public void disableServerWithTimeout(int ssid, Optional<Duration> timeout) {
        this.anjay.disableServerWithTimeout(ssid, timeout);
    }

    public boolean isOffline(Set<Transport> transportSet) {
        return this.anjay.isOffline(transportSet);
    }

    public boolean isOffline() {
        return this.isOffline(EnumSet.allOf(Transport.class));
    }

    public void enterOffline(Set<Transport> transportSet) {
        this.anjay.enterOffline(transportSet);
    }

    public void enterOffline() {
        this.enterOffline(EnumSet.allOf(Transport.class));
    }

    public void exitOffline(Set<Transport> transportSet) {
        this.anjay.exitOffline(transportSet);
    }

    public void exitOffline() {
        this.exitOffline(EnumSet.allOf(Transport.class));
    }

    public void notifyChanged(int oid, int iid, int rid) {
        this.anjay.notifyChanged(oid, iid, rid);
    }

    public void notifyInstancesChanged(int oid) {
        this.anjay.notifyInstancesChanged(oid);
    }

    public void registerObject(AnjayObject object) {
        this.anjay.registerObject(object);
    }

    public Optional<AnjaySecurityConfigFromDm> securityConfigFromDm(String uri) {
        if (this.anjay.hasSecurityConfigForUri(uri)) {
            return Optional.of(new AnjaySecurityConfigFromDm(uri));
        }
        return Optional.empty();
    }

    public static final class SocketEntry {
        public final SelectableChannel channel;
        public final Transport transport;
        public final int ssid;
        public final boolean queueMode;
        public final int port;

        public SocketEntry(SelectableChannel channel, Transport transport, int ssid, boolean queueMode, int port) {
            this.channel = channel;
            this.transport = transport;
            this.ssid = ssid;
            this.queueMode = queueMode;
            this.port = port;
        }
    }

    public static enum DtlsVersion {
        DEFAULT,
        SSLv2_OR_3,
        SSLv2,
        SSLv3,
        TLSv1,
        TLSv1_1,
        TLSv1_2;

    }

    public static enum Transport {
        UDP,
        TCP;

    }

    public static final class Objlnk {
        public final int oid;
        public final int iid;

        public Objlnk(int oid, int iid) {
            this.oid = oid;
            this.iid = iid;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || !(other instanceof Objlnk)) {
                return false;
            }
            return ((Objlnk)other).oid == this.oid && ((Objlnk)other).iid == this.iid;
        }

        public int hashCode() {
            int[] pair = new int[]{this.oid, this.iid};
            return Arrays.hashCode(pair);
        }
    }

    public static final class CoapUdpTxParams {
        public final Duration ackTimeout;
        public final double ackRandomFactor;
        public final int maxRetransmit;
        public final int nstart;
        public static final CoapUdpTxParams DEFAULT = new CoapUdpTxParams(Duration.ofSeconds(2L, 0L), 1.5, 4, 1);

        public CoapUdpTxParams(Duration ackTimeout, double ackRandomFactor, int maxRetransmit, int nstart) {
            this.ackTimeout = Objects.requireNonNull(ackTimeout, "ackTimeout MUST NOT be null");
            this.ackRandomFactor = ackRandomFactor;
            this.maxRetransmit = maxRetransmit;
            this.nstart = nstart;
        }
    }

    public static final class Lwm2mVersionConfig {
        public final Lwm2mVersion minimumVersion;
        public final Lwm2mVersion maximumVersion;

        public Lwm2mVersionConfig(Lwm2mVersion minimum, Lwm2mVersion maximum) {
            this.minimumVersion = Objects.requireNonNull(minimum, "minimum LwM2M version MUST NOT be null");
            this.maximumVersion = Objects.requireNonNull(maximum, "maximum LwM2M version MUST NOT be null");
        }
    }

    public static enum Lwm2mVersion {
        VERSION_1_0("1.0"),
        VERSION_1_1("1.1");

        private final String stringValue;

        private Lwm2mVersion(String stringValue) {
            this.stringValue = stringValue;
        }

        public String toString() {
            return this.stringValue;
        }
    }

    public static class DtlsHandshakeTimeouts {
        public final Duration min;
        public final Duration max;

        public DtlsHandshakeTimeouts(Duration min, Duration max) {
            this.min = Objects.requireNonNull(min, "min duration MUST NOT be null");
            this.max = Objects.requireNonNull(max, "min duration MUST NOT be null");
        }
    }

    public static final class Configuration {
        public String endpointName;
        public int udpListenPort;
        public Optional<DtlsVersion> dtlsVersion = Optional.empty();
        public long inBufferSize;
        public long outBufferSize;
        public long msgCacheSize;
        public Optional<CoapUdpTxParams> udpTxParams = Optional.empty();
        public Optional<DtlsHandshakeTimeouts> udpDtlsHsTxParams = Optional.empty();
        public boolean confirmableNotifications;
        public boolean disableLegacyServerInitiatedBootstrap;
        public long storedNotificationLimit;
        public boolean preferHierarchicalFormats;
        public boolean useConnectionId;
        public Optional<int[]> defaultTlsCiphersuites = Optional.empty();
    }
}

