/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay;

import com.avsystem.anjay.AnjayInputContext;
import com.avsystem.anjay.AnjayOutputContext;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;

public interface AnjayObject {
    public int oid();

    default public String version() {
        return "1.0";
    }

    public SortedSet<Integer> instances();

    default public void instanceReset(int iid) throws Exception {
        throw new UnsupportedOperationException("instanceReset is not implemented");
    }

    default public void instanceCreate(int iid) throws Exception {
        throw new UnsupportedOperationException("instanceCreate is not implemented");
    }

    default public void instanceRemove(int iid) throws Exception {
        throw new UnsupportedOperationException("instanceRemove is not implemented");
    }

    default public SortedSet<ResourceDef> resources(int iid) {
        return null;
    }

    default public void resourceRead(int iid, int rid, AnjayOutputContext context) throws Exception {
        throw new UnsupportedOperationException("resourceRead on Resource is not implemented");
    }

    default public void resourceRead(int iid, int rid, int riid, AnjayOutputContext context) throws Exception {
        throw new UnsupportedOperationException("resourceRead on Resource Instance is not implemented");
    }

    default public void resourceWrite(int iid, int rid, AnjayInputContext context) throws Exception {
        throw new UnsupportedOperationException("resourceWrite on Resource is not implemented");
    }

    default public void resourceWrite(int iid, int rid, int riid, AnjayInputContext context) throws Exception {
        throw new UnsupportedOperationException("resourceWrite on Resource Instance is not implemented");
    }

    default public void resourceExecute(int iid, int rid, Map<Integer, Optional<String>> args) throws Exception {
        throw new UnsupportedOperationException("resourceExecute is not implemented");
    }

    default public void resourceReset(int iid, int rid) throws Exception {
        throw new UnsupportedOperationException("resourceReset is not implemented");
    }

    default public SortedSet<Integer> resourceInstances(int iid, int rid) throws Exception {
        return null;
    }

    default public void transactionBegin() throws Exception {
        throw new UnsupportedOperationException("transactionBegin is not implemented");
    }

    default public void transactionValidate() throws Exception {
        throw new UnsupportedOperationException("transactionValidate is not implemented");
    }

    default public void transactionCommit() throws Exception {
        throw new UnsupportedOperationException("transcationCommit is not implemented");
    }

    default public void transactionRollback() throws Exception {
        throw new UnsupportedOperationException("transactionRollback is not implemented");
    }

    public static final class ResourceDef
    implements Comparable<ResourceDef> {
        public final int rid;
        public final ResourceKind kind;
        public final boolean present;

        public ResourceDef(int rid, ResourceKind kind, boolean present) {
            this.rid = rid;
            this.kind = kind;
            this.present = present;
        }

        @Override
        public int compareTo(ResourceDef other) {
            return this.rid - other.rid;
        }

        public boolean equals(Object other) {
            if (other == this) {
                return true;
            }
            if (other == null || !(other instanceof ResourceDef)) {
                return false;
            }
            ResourceDef def = (ResourceDef)other;
            return def.rid == this.rid && def.kind.equals((Object)this.kind) && def.present == this.present;
        }

        public int hashCode() {
            int hash = 31 * this.rid;
            hash = 31 * hash + this.kind.hashCode();
            hash = 31 * hash + Boolean.hashCode(this.present);
            return hash;
        }
    }

    public static enum ResourceKind {
        R,
        W,
        RW,
        RM,
        WM,
        RWM,
        E,
        BS_RW;

    }
}

