/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.AnjayBytesContext;
import com.avsystem.anjay.AnjayException;
import com.avsystem.anjay.impl.NativeOutputContext;
import com.avsystem.anjay.impl.NativeOutputContextPointer;
import java.nio.ByteBuffer;

public final class AnjayOutputContext
implements AutoCloseable {
    private NativeOutputContext context;

    @Override
    public void close() {
        this.context = null;
    }

    private NativeOutputContext getContext() {
        if (this.context == null) {
            throw new IllegalStateException("Attempted to use closed AnjayOutputContext");
        }
        return this.context;
    }

    public AnjayOutputContext(NativeOutputContextPointer pointer) {
        this.context = new NativeOutputContext(pointer);
    }

    public void retInt(int value) throws AnjayException {
        this.getContext().retInt(value);
    }

    public void retLong(long value) throws AnjayException {
        this.getContext().retLong(value);
    }

    public void retFloat(float value) throws AnjayException {
        this.getContext().retFloat(value);
    }

    public void retDouble(double value) throws AnjayException {
        this.getContext().retDouble(value);
    }

    public void retBoolean(boolean value) throws AnjayException {
        this.getContext().retBoolean(value);
    }

    public void retString(String value) throws AnjayException {
        this.getContext().retString(value);
    }

    public void retObjlnk(Anjay.Objlnk value) throws AnjayException {
        this.getContext().retObjlnk(value);
    }

    public AnjayBytesContext retBytes(int length) throws AnjayException {
        return new AnjayBytesContext(this.getContext().retBytes(length));
    }

    public void retBytes(ByteBuffer buffer) throws AnjayException {
        ByteBuffer slice = buffer.slice();
        try (AnjayBytesContext context = this.retBytes(slice.capacity());){
            context.append(slice);
        }
    }

    public void retBytes(byte[] array, int offset, int length) throws AnjayException {
        this.retBytes(ByteBuffer.wrap(array, offset, length));
    }

    public void retBytes(byte[] array) throws AnjayException {
        this.retBytes(ByteBuffer.wrap(array));
    }
}

