/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.impl.NativeSecurityObject;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Optional;

public final class AnjaySecurityObject {
    private final NativeSecurityObject security;

    private AnjaySecurityObject(Anjay anjay) throws Exception {
        this.security = new NativeSecurityObject(anjay);
    }

    public static AnjaySecurityObject install(Anjay anjay) throws Exception {
        return new AnjaySecurityObject(anjay);
    }

    public int addInstance(Instance instance) throws Exception {
        return this.addInstance(instance, Anjay.ID_INVALID);
    }

    public int addInstance(Instance instance, int preferredIid) throws Exception {
        return this.security.addInstance(instance, preferredIid);
    }

    public void purge() {
        this.security.purge();
    }

    public void persist(OutputStream outputStream) throws Exception {
        this.security.persist(outputStream);
    }

    public void restore(InputStream inputStream) throws Exception {
        this.security.restore(inputStream);
    }

    public boolean isModified() {
        return this.security.isModified();
    }

    public static final class Instance {
        public int ssid;
        public Optional<String> serverUri = Optional.empty();
        public boolean bootstrapServer;
        public SecurityMode securityMode;
        public Optional<Integer> clientHoldoffS = Optional.empty();
        public Optional<Integer> bootstrapTimeoutS = Optional.empty();
        public Optional<byte[]> publicCertOrPskIdentity = Optional.empty();
        public Optional<byte[]> privateCertOrPskKey = Optional.empty();
        public Optional<byte[]> serverPublicKey = Optional.empty();
        public SmsSecurityMode smsSecurityMode = SmsSecurityMode.NOSEC;
        public Optional<byte[]> smsKeyParameters = Optional.empty();
        public Optional<byte[]> smsSecretKey = Optional.empty();
        public Optional<String> serverSmsNumber = Optional.empty();
    }

    public static enum SmsSecurityMode {
        DTLS_PSK,
        SECURE_PACKET,
        NOSEC;

    }

    public static enum SecurityMode {
        PSK("psk"),
        RPK("rpk"),
        CERTIFICATE("cert"),
        NOSEC("nosec"),
        EST("est");

        private final String name;

        public String toString() {
            return this.name;
        }

        private SecurityMode(String s) {
            this.name = s;
        }
    }
}

