/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay.impl;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.AnjayException;
import com.avsystem.anjay.AnjayObject;
import com.avsystem.anjay.impl.NativeAnjayObject;
import com.avsystem.anjay.impl.NativeSocketEntry;
import com.avsystem.anjay.impl.NativeTransportSet;
import java.nio.channels.SelectableChannel;
import java.time.Duration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class NativeAnjay
implements AutoCloseable {
    private long self;
    private final List<Anjay.SocketEntry> sockets;
    private final Map<Anjay.SocketEntry, NativeSocketEntry> nativeSockets;

    private native NativeSocketEntry[] anjayGetSocketEntries();

    private native void anjayServe(long var1);

    private native void anjaySchedRun();

    private native Duration anjaySchedTimeToNext();

    private native int anjayScheduleRegistrationUpdate(int var1);

    private native int anjayScheduleTransportReconnect(NativeTransportSet var1);

    private native boolean anjayTransportIsOffline(NativeTransportSet var1);

    private native int anjayTransportEnterOffline(NativeTransportSet var1);

    private native int anjayTransportExitOffline(NativeTransportSet var1);

    private native int anjayDisableServer(int var1);

    private native int anjayDisableServerWithTimeout(int var1, Optional<Duration> var2);

    private native int anjayEnableServer(int var1);

    private native int anjayNotifyChanged(int var1, int var2, int var3);

    private native int anjayNotifyInstancesChanged(int var1);

    private native int anjayRegisterObject(NativeAnjayObject var1);

    private native boolean anjayHasSecurityConfigForUri(String var1);

    private native void init(Anjay.Configuration var1);

    private native void cleanup();

    public static native String getVersion();

    public static native int getSsidAny();

    public static native int getSsidBootstrap();

    public static native int getIdInvalid();

    public static native int getErrorBadRequest();

    public static native int getErrorUnauthorized();

    public static native int getErrorBadOption();

    public static native int getErrorNotFound();

    public static native int getErrorMethodNotAllowed();

    public static native int getErrorNotAcceptable();

    public static native int getErrorRequestEntityIncomplete();

    public static native int getErrorInternal();

    public static native int getErrorNotImplemented();

    public static native int getErrorServiceUnavailable();

    void ensureValidState() {
        if (this.self == 0L) {
            throw new IllegalStateException("Attempted to use a closed NativeAnjay object");
        }
    }

    public NativeAnjay(Anjay.Configuration config) {
        this.init(config);
        this.sockets = new ArrayList<Anjay.SocketEntry>();
        this.nativeSockets = new HashMap<Anjay.SocketEntry, NativeSocketEntry>();
    }

    @Override
    public void close() {
        this.cleanup();
        this.self = 0L;
    }

    public List<Anjay.SocketEntry> getSocketEntries() {
        this.ensureValidState();
        this.sockets.clear();
        this.nativeSockets.clear();
        for (NativeSocketEntry entry : this.anjayGetSocketEntries()) {
            Anjay.SocketEntry socket = entry.intoSocketEntry();
            this.sockets.add(socket);
            this.nativeSockets.put(socket, entry);
        }
        return this.sockets;
    }

    public void schedRun() {
        this.ensureValidState();
        this.anjaySchedRun();
    }

    public void serve(SelectableChannel channel) {
        this.ensureValidState();
        for (Anjay.SocketEntry entry : this.sockets) {
            if (entry.channel != channel) continue;
            this.anjayServe(this.nativeSockets.get(entry).getSocketPtr());
            return;
        }
        throw new IllegalArgumentException("Passed channel does not belong to any known channels");
    }

    public Optional<Duration> timeToNext() {
        this.ensureValidState();
        return Optional.ofNullable(this.anjaySchedTimeToNext());
    }

    public void scheduleRegistrationUpdate(int ssid) {
        this.ensureValidState();
        int result = this.anjayScheduleRegistrationUpdate(ssid);
        if (result < 0) {
            throw new AnjayException(result, "anjay_schedule_registration_update() failed");
        }
    }

    public void scheduleReconnect(Set<Anjay.Transport> transportSet) {
        this.ensureValidState();
        int result = this.anjayScheduleTransportReconnect(NativeTransportSet.fromSet(transportSet));
        if (result < 0) {
            throw new AnjayException(result, "anjay_schedule_reconnect() failed");
        }
    }

    public boolean isOffline(Set<Anjay.Transport> transportSet) {
        this.ensureValidState();
        return this.anjayTransportIsOffline(NativeTransportSet.fromSet(transportSet));
    }

    public void enterOffline(Set<Anjay.Transport> transportSet) {
        this.ensureValidState();
        int result = this.anjayTransportEnterOffline(NativeTransportSet.fromSet(transportSet));
        if (result < 0) {
            throw new AnjayException(result, "anjay_transport_enter_offline() failed");
        }
    }

    public void exitOffline(Set<Anjay.Transport> transportSet) {
        this.ensureValidState();
        int result = this.anjayTransportExitOffline(NativeTransportSet.fromSet(transportSet));
        if (result < 0) {
            throw new AnjayException(result, "anjay_transport_exit_offline() failed");
        }
    }

    public void disableServer(int ssid) {
        this.ensureValidState();
        int result = this.anjayDisableServer(ssid);
        if (result < 0) {
            throw new AnjayException(result, "anjay_disable_server() failed");
        }
    }

    public void enableServer(int ssid) {
        this.ensureValidState();
        int result = this.anjayEnableServer(ssid);
        if (result < 0) {
            throw new AnjayException(result, "anjay_enable_server() failed");
        }
    }

    public void disableServerWithTimeout(int ssid, Optional<Duration> timeout) {
        this.ensureValidState();
        int result = this.anjayDisableServerWithTimeout(ssid, timeout);
        if (result < 0) {
            throw new AnjayException(result, "anjay_disable_server_with_timeout() failed");
        }
    }

    public void notifyChanged(int oid, int iid, int rid) {
        this.ensureValidState();
        int result = this.anjayNotifyChanged(oid, iid, rid);
        if (result < 0) {
            throw new AnjayException(result, "anjay_notify_changed() failed");
        }
    }

    public void notifyInstancesChanged(int oid) {
        this.ensureValidState();
        int result = this.anjayNotifyInstancesChanged(oid);
        if (result < 0) {
            throw new AnjayException(result, "anjay_notify_instances_changed() failed");
        }
    }

    public void registerObject(AnjayObject object) {
        this.ensureValidState();
        if (object == null) {
            throw new AnjayException(-1, "attempted to register null object");
        }
        int result = this.anjayRegisterObject(new NativeAnjayObject(object));
        if (result < 0) {
            throw new AnjayException(result, "anjay_register_object() failed");
        }
    }

    public boolean hasSecurityConfigForUri(String uri) {
        return this.anjayHasSecurityConfigForUri(uri);
    }

    static {
        System.loadLibrary("anjay-jni");
    }
}

