/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay.impl;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.AnjayAttributes;
import com.avsystem.anjay.AnjayInputContext;
import com.avsystem.anjay.AnjayObject;
import com.avsystem.anjay.AnjayObjectAttrHandlers;
import com.avsystem.anjay.AnjayOutputContext;
import com.avsystem.anjay.impl.NativeInputContextPointer;
import com.avsystem.anjay.impl.NativeOutputContextPointer;
import com.avsystem.anjay.impl.Utils;
import java.util.Map;
import java.util.Optional;
import java.util.SortedSet;

public final class NativeAnjayObject {
    private final AnjayObject object;
    private static final Integer[] EMPTY_INSTANCES_ARRAY = new Integer[0];
    private static final AnjayObject.ResourceDef[] EMPTY_RESOURCES_ARRAY = new AnjayObject.ResourceDef[0];

    public NativeAnjayObject(AnjayObject object) {
        this.object = object;
    }

    int oid() {
        return this.object.oid();
    }

    String version() {
        return this.object.version();
    }

    int resourceWrite(int iid, int rid, int riid, NativeInputContextPointer ptr) {
        AnjayInputContext wrapper = new AnjayInputContext(ptr);
        try {
            if (riid == Anjay.ID_INVALID) {
                this.object.resourceWrite(iid, rid, wrapper);
            } else {
                this.object.resourceWrite(iid, rid, riid, wrapper);
            }
            int n = 0;
            wrapper.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    wrapper.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                return Utils.handleException(t);
            }
        }
    }

    int resourceRead(int iid, int rid, int riid, NativeOutputContextPointer ptr) {
        AnjayOutputContext wrapper = new AnjayOutputContext(ptr);
        try {
            if (riid == Anjay.ID_INVALID) {
                this.object.resourceRead(iid, rid, wrapper);
            } else {
                this.object.resourceRead(iid, rid, riid, wrapper);
            }
            int n = 0;
            wrapper.close();
            return n;
        }
        catch (Throwable throwable) {
            try {
                try {
                    wrapper.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable t) {
                return Utils.handleException(t);
            }
        }
    }

    int resourceExecute(int iid, int rid, Map<Integer, Optional<String>> args) {
        try {
            this.object.resourceExecute(iid, rid, args);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int resourceReset(int iid, int rid) {
        try {
            this.object.resourceReset(iid, rid);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int instances(IntegerArrayByReference result) {
        try {
            SortedSet<Integer> instances = this.object.instances();
            result.value = instances == null ? EMPTY_INSTANCES_ARRAY : instances.toArray(new Integer[instances.size()]);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int resources(int iid, ResourceDefArrayByReference result) {
        try {
            SortedSet<AnjayObject.ResourceDef> resources = this.object.resources(iid);
            result.value = resources == null ? EMPTY_RESOURCES_ARRAY : resources.toArray(new AnjayObject.ResourceDef[resources.size()]);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int resourceInstances(int iid, int rid, IntegerArrayByReference result) {
        try {
            SortedSet<Integer> instances = this.object.resourceInstances(iid, rid);
            result.value = instances == null ? EMPTY_INSTANCES_ARRAY : instances.toArray(new Integer[instances.size()]);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int instanceReset(int iid) {
        try {
            this.object.instanceReset(iid);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int instanceCreate(int iid) {
        try {
            this.object.instanceCreate(iid);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int instanceRemove(int iid) {
        try {
            this.object.instanceRemove(iid);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int transactionBegin() {
        try {
            this.object.transactionBegin();
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int transactionValidate() {
        try {
            this.object.transactionValidate();
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int transactionCommit() {
        try {
            this.object.transactionCommit();
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int transactionRollback() {
        try {
            this.object.transactionRollback();
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    boolean implementsAttrHandlers() {
        return this.object instanceof AnjayObjectAttrHandlers;
    }

    int objectReadDefaultAttrs(int ssid, ObjectInstanceAttrsByReference attrs) {
        assert (this.implementsAttrHandlers()) : "bug: should not be called when object doesn't implement attribute handlers";
        AnjayObjectAttrHandlers handlers = (AnjayObjectAttrHandlers)((Object)this.object);
        try {
            attrs.value = handlers.objectReadDefaultAttrs(ssid);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int objectWriteDefaultAttrs(int ssid, AnjayAttributes.ObjectInstanceAttrs attrs) {
        assert (this.implementsAttrHandlers()) : "bug: should not be called when object doesn't implement attribute handlers";
        AnjayObjectAttrHandlers handlers = (AnjayObjectAttrHandlers)((Object)this.object);
        try {
            handlers.objectWriteDefaultAttrs(ssid, attrs);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int instanceReadDefaultAttrs(int iid, int ssid, ObjectInstanceAttrsByReference attrs) {
        assert (this.implementsAttrHandlers()) : "bug: should not be called when object doesn't implement attribute handlers";
        AnjayObjectAttrHandlers handlers = (AnjayObjectAttrHandlers)((Object)this.object);
        try {
            attrs.value = handlers.instanceReadDefaultAttrs(iid, ssid);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int instanceWriteDefaultAttrs(int iid, int ssid, AnjayAttributes.ObjectInstanceAttrs attrs) {
        assert (this.implementsAttrHandlers()) : "bug: should not be called when object doesn't implement attribute handlers";
        AnjayObjectAttrHandlers handlers = (AnjayObjectAttrHandlers)((Object)this.object);
        try {
            handlers.instanceWriteDefaultAttrs(iid, ssid, attrs);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int resourceReadAttrs(int iid, int rid, int ssid, ResourceAttrsByReference attrs) {
        assert (this.implementsAttrHandlers()) : "bug: should not be called when object doesn't implement attribute handlers";
        AnjayObjectAttrHandlers handlers = (AnjayObjectAttrHandlers)((Object)this.object);
        try {
            attrs.value = handlers.resourceReadAttrs(iid, rid, ssid);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    int resourceWriteAttrs(int iid, int rid, int ssid, AnjayAttributes.ResourceAttrs attrs) {
        assert (this.implementsAttrHandlers()) : "bug: should not be called when object doesn't implement attribute handlers";
        AnjayObjectAttrHandlers handlers = (AnjayObjectAttrHandlers)((Object)this.object);
        try {
            handlers.resourceWriteAttrs(iid, rid, ssid, attrs);
            return 0;
        }
        catch (Throwable t) {
            return Utils.handleException(t);
        }
    }

    public static final class ResourceAttrsByReference {
        public AnjayAttributes.ResourceAttrs value;
    }

    public static final class ObjectInstanceAttrsByReference {
        public AnjayAttributes.ObjectInstanceAttrs value;
    }

    private static class ResourceDefArrayByReference {
        public AnjayObject.ResourceDef[] value;

        private ResourceDefArrayByReference() {
        }
    }

    private static class IntegerArrayByReference {
        public Integer[] value;

        private IntegerArrayByReference() {
        }
    }
}

