/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay.impl;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.AnjayAttributes;
import com.avsystem.anjay.AnjayException;
import com.avsystem.anjay.impl.NativeAnjay;
import com.avsystem.anjay.impl.NativeUtils;
import java.io.InputStream;
import java.io.OutputStream;

public class NativeAttrStorage {
    private long self;

    private native void init(NativeAnjay var1);

    private native void cleanup();

    private native void attrStoragePurge();

    private native void attrStorageSetObjectAttrs(int var1, int var2, AnjayAttributes.ObjectInstanceAttrs var3);

    private native void attrStorageSetInstanceAttrs(int var1, int var2, int var3, AnjayAttributes.ObjectInstanceAttrs var4);

    private native void attrStorageSetResourceAttrs(int var1, int var2, int var3, int var4, AnjayAttributes.ResourceAttrs var5);

    private native int attrStoragePersist(OutputStream var1);

    private native int attrStorageRestore(InputStream var1);

    private native boolean attrStorageIsModified();

    public static native int getAttrPeriodNone();

    public static native double getAttrValueNone();

    public NativeAttrStorage(Anjay anjay) throws Exception {
        this.init(NativeUtils.getNativeAnjay(anjay));
    }

    public void purge() {
        this.attrStoragePurge();
    }

    public void setObjectAttrs(int ssid, int oid, AnjayAttributes.ObjectInstanceAttrs attrs) {
        this.attrStorageSetObjectAttrs(ssid, oid, attrs);
    }

    public void setInstanceAttrs(int ssid, int oid, int iid, AnjayAttributes.ObjectInstanceAttrs attrs) {
        this.attrStorageSetInstanceAttrs(ssid, oid, iid, attrs);
    }

    public void setResourceAttrs(int ssid, int oid, int iid, int rid, AnjayAttributes.ResourceAttrs attrs) {
        this.attrStorageSetResourceAttrs(ssid, oid, iid, rid, attrs);
    }

    public void persist(OutputStream output_stream) {
        int result = this.attrStoragePersist(output_stream);
        if (result < 0) {
            throw new AnjayException(result, "failed to persist Attribute storage");
        }
    }

    public void restore(InputStream input_stream) {
        int result = this.attrStorageRestore(input_stream);
        if (result < 0) {
            throw new AnjayException(result, "failed to restore Attribute storage");
        }
    }

    public boolean isModified() {
        return this.attrStorageIsModified();
    }
}

