/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay.impl;

import com.avsystem.anjay.AnjayException;
import com.avsystem.anjay.impl.NativeBytesContextPointer;
import java.nio.ByteBuffer;

public final class NativeBytesContext
implements AutoCloseable {
    private long self;
    private int remaining;

    private native void init(NativeBytesContextPointer var1);

    private native void cleanup();

    private native int anjayRetBytesAppend(byte[] var1, int var2);

    public NativeBytesContext(NativeBytesContextPointer context, int remaining) {
        this.init(context);
        this.remaining = remaining;
    }

    public void append(ByteBuffer buffer) {
        if (this.remaining < buffer.remaining()) {
            throw new IllegalStateException("Too many bytes passed to bytes context");
        }
        ByteBuffer slice = buffer.slice();
        byte[] chunk = new byte[Math.min(4096, slice.capacity())];
        while (slice.hasRemaining()) {
            int length = Math.min(chunk.length, slice.remaining());
            slice.get(chunk, 0, length);
            this.remaining -= length;
            int result = this.anjayRetBytesAppend(chunk, length);
            if (result >= 0) continue;
            throw new AnjayException(result, "anjay_ret_bytes_append() failed");
        }
    }

    @Override
    public void close() {
        this.cleanup();
    }
}

