/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay.impl;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.AnjayAbstractSecurityConfig;
import com.avsystem.anjay.AnjayFirmwareUpdateException;
import com.avsystem.anjay.AnjayFirmwareUpdateHandlers;
import java.util.Optional;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class NativeFirmwareUpdateHandlers {
    private final AnjayFirmwareUpdateHandlers handlers;
    private static final Logger LOGGER = Logger.getLogger(NativeFirmwareUpdateHandlers.class.getName());

    private static int handleException(Throwable t) {
        LOGGER.log(Level.FINE, "Exception occurred", t);
        if (t instanceof AnjayFirmwareUpdateException) {
            return ((AnjayFirmwareUpdateException)t).errorCode();
        }
        return -1;
    }

    public NativeFirmwareUpdateHandlers(AnjayFirmwareUpdateHandlers handlers) {
        this.handlers = handlers;
    }

    int streamOpen(Optional<String> packageUri, Optional<byte[]> etag) {
        try {
            this.handlers.streamOpen(packageUri, etag);
            return 0;
        }
        catch (Throwable t) {
            return NativeFirmwareUpdateHandlers.handleException(t);
        }
    }

    int streamWrite(byte[] data) {
        try {
            this.handlers.streamWrite(data);
            return 0;
        }
        catch (Throwable t) {
            return NativeFirmwareUpdateHandlers.handleException(t);
        }
    }

    int streamFinish() {
        try {
            this.handlers.streamFinish();
            return 0;
        }
        catch (Throwable t) {
            return NativeFirmwareUpdateHandlers.handleException(t);
        }
    }

    void reset() {
        this.handlers.reset();
    }

    String getName() {
        return this.handlers.getName();
    }

    String getVersion() {
        return this.handlers.getVersion();
    }

    int performUpgrade() {
        try {
            this.handlers.performUpgrade();
            return 0;
        }
        catch (Throwable t) {
            return NativeFirmwareUpdateHandlers.handleException(t);
        }
    }

    AnjayAbstractSecurityConfig getSecurityConfig(String uri) {
        return this.handlers.getSecurityConfig(uri);
    }

    Anjay.CoapUdpTxParams getCoapTxParams(Optional<String> downloadUri) {
        return this.handlers.getCoapTxParams(downloadUri);
    }
}

