/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay.impl;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.AnjayException;
import com.avsystem.anjay.impl.NativeInputContextPointer;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;

public final class NativeInputContext
implements AutoCloseable {
    private long self;

    private native void init(NativeInputContextPointer var1);

    private native void cleanup();

    private native int anjayGetBytes(BytesContext var1);

    private native int anjayGetString(StringContext var1);

    private native int anjayGetI32(IntegerContext var1);

    private native int anjayGetI64(LongContext var1);

    private native int anjayGetFloat(FloatContext var1);

    private native int anjayGetDouble(DoubleContext var1);

    private native int anjayGetBool(BooleanContext var1);

    private native int anjayGetObjlnk(ObjlnkContext var1);

    public NativeInputContext(NativeInputContextPointer context) {
        this.init(context);
    }

    public int getInt() {
        IntegerContext context = new IntegerContext();
        int result = this.anjayGetI32(context);
        if (result < 0) {
            throw new AnjayException(result, "anjay_get_i32() failed");
        }
        return context.value;
    }

    public long getLong() {
        LongContext context = new LongContext();
        int result = this.anjayGetI64(context);
        if (result < 0) {
            throw new AnjayException(result, "anjay_get_i64() failed");
        }
        return context.value;
    }

    public float getFloat() {
        FloatContext context = new FloatContext();
        int result = this.anjayGetFloat(context);
        if (result < 0) {
            throw new AnjayException(result, "anjay_get_float() failed");
        }
        return context.value;
    }

    public double getDouble() {
        DoubleContext context = new DoubleContext();
        int result = this.anjayGetDouble(context);
        if (result < 0) {
            throw new AnjayException(result, "anjay_get_double() failed");
        }
        return context.value;
    }

    public boolean getBoolean() {
        BooleanContext context = new BooleanContext();
        int result = this.anjayGetBool(context);
        if (result < 0) {
            throw new AnjayException(result, "anjay_get_bool() failed");
        }
        return context.value;
    }

    public String getString() {
        StringContext context = new StringContext();
        int result = this.anjayGetString(context);
        if (result < 0) {
            throw new AnjayException(result, "anjay_get_string() failed");
        }
        return context.value;
    }

    public Anjay.Objlnk getObjlnk() {
        ObjlnkContext context = new ObjlnkContext();
        int result = this.anjayGetObjlnk(context);
        if (result < 0) {
            throw new AnjayException(result, "anjay_get_objlnk() failed");
        }
        return context.value;
    }

    public boolean getBytes(ByteBuffer out) {
        int position = out.position();
        BytesContext context = new BytesContext(out.slice());
        int result = this.anjayGetBytes(context);
        if (result < 0) {
            throw new AnjayException(result, "anjay_get_bytes() failed");
        }
        out.position(position + context.bytesRead);
        return context.messageFinished;
    }

    public byte[] getAllBytes() {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ByteBuffer buf = ByteBuffer.allocate(4096);
        boolean finished = false;
        while (!finished) {
            buf.clear();
            finished = this.getBytes(buf);
            output.write(buf.array(), 0, buf.position());
        }
        return output.toByteArray();
    }

    @Override
    public void close() {
        this.cleanup();
    }

    private static final class ObjlnkContext {
        public Anjay.Objlnk value;

        private ObjlnkContext() {
        }
    }

    private static final class DoubleContext {
        public double value;

        private DoubleContext() {
        }
    }

    private static final class FloatContext {
        public float value;

        private FloatContext() {
        }
    }

    private static final class LongContext {
        public long value;

        private LongContext() {
        }
    }

    private static final class IntegerContext {
        public int value;

        private IntegerContext() {
        }
    }

    private static final class BooleanContext {
        public boolean value;

        private BooleanContext() {
        }
    }

    private static final class StringContext {
        public String value;

        private StringContext() {
        }
    }

    private static final class BytesContext {
        public boolean messageFinished = false;
        public ByteBuffer slice;
        public int bytesRead;

        public BytesContext(ByteBuffer slice) {
            this.slice = slice;
            this.bytesRead = 0;
        }
    }
}

