/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay.impl;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.AnjayException;
import com.avsystem.anjay.impl.NativeBytesContext;
import com.avsystem.anjay.impl.NativeBytesContextPointer;
import com.avsystem.anjay.impl.NativeOutputContextPointer;

public final class NativeOutputContext
implements AutoCloseable {
    private long self;

    private native void init(NativeOutputContextPointer var1);

    private native void cleanup();

    private native int anjayRetString(String var1);

    private native int anjayRetI32(int var1);

    private native int anjayRetI64(long var1);

    private native int anjayRetFloat(float var1);

    private native int anjayRetDouble(double var1);

    private native int anjayRetBool(boolean var1);

    private native int anjayRetObjlnk(Anjay.Objlnk var1);

    private native NativeBytesContextPointer anjayRetBytesBegin(int var1);

    public NativeOutputContext(NativeOutputContextPointer context) {
        this.init(context);
    }

    public void retInt(int value) {
        int result = this.anjayRetI32(value);
        if (result < 0) {
            throw new AnjayException(result, "anjay_ret_i32() failed");
        }
    }

    public void retLong(long value) {
        int result = this.anjayRetI64(value);
        if (result < 0) {
            throw new AnjayException(result, "anjay_ret_i64() failed");
        }
    }

    public void retFloat(float value) {
        int result = this.anjayRetFloat(value);
        if (result < 0) {
            throw new AnjayException(result, "anjay_ret_float() failed");
        }
    }

    public void retDouble(double value) {
        int result = this.anjayRetDouble(value);
        if (result < 0) {
            throw new AnjayException(result, "anjay_ret_double() failed");
        }
    }

    public void retBoolean(boolean value) {
        int result = this.anjayRetBool(value);
        if (result < 0) {
            throw new AnjayException(result, "anjay_ret_bool() failed");
        }
    }

    public void retString(String value) {
        int result = this.anjayRetString(value);
        if (result < 0) {
            throw new AnjayException(result, "anjay_ret_string() failed");
        }
    }

    public NativeBytesContext retBytes(int length) {
        NativeBytesContextPointer pointer = this.anjayRetBytesBegin(length);
        if (pointer.isNull()) {
            throw new AnjayException(-1, "anjay_ret_bytes_begin() failed");
        }
        return new NativeBytesContext(pointer, length);
    }

    public void retObjlnk(Anjay.Objlnk value) {
        int result = this.anjayRetObjlnk(value);
        if (result < 0) {
            throw new AnjayException(result, "anjay_ret_objlnk() failed");
        }
    }

    @Override
    public void close() {
        this.cleanup();
    }
}

