/*
 * Decompiled with CFR 0.152.
 */
package com.avsystem.anjay.impl;

import com.avsystem.anjay.Anjay;
import com.avsystem.anjay.AnjayException;
import com.avsystem.anjay.AnjaySecurityObject;
import com.avsystem.anjay.impl.NativeAnjay;
import com.avsystem.anjay.impl.NativeUtils;
import java.io.InputStream;
import java.io.OutputStream;

public final class NativeSecurityObject {
    private long self;

    private native void init(NativeAnjay var1);

    private native void cleanup();

    private native int anjaySecurityObjectAddInstance(AnjaySecurityObject.Instance var1, int var2);

    private native void anjaySecurityObjectPurge();

    private native int anjaySecurityObjectPersist(OutputStream var1);

    private native int anjaySecurityObjectRestore(InputStream var1);

    private native boolean anjaySecurityObjectIsModified();

    public NativeSecurityObject(Anjay anjay) throws Exception {
        this.init(NativeUtils.getNativeAnjay(anjay));
    }

    public int addInstance(AnjaySecurityObject.Instance instance, int preferredIid) {
        int result = this.anjaySecurityObjectAddInstance(instance, preferredIid);
        if (result < 0) {
            throw new AnjayException(result, "anjay_security_add_instance() failed");
        }
        return result;
    }

    public void purge() {
        this.anjaySecurityObjectPurge();
    }

    public void persist(OutputStream output_stream) {
        int result = this.anjaySecurityObjectPersist(output_stream);
        if (result < 0) {
            throw new AnjayException(result, "failed to persist Security object");
        }
    }

    public void restore(InputStream input_stream) {
        int result = this.anjaySecurityObjectRestore(input_stream);
        if (result < 0) {
            throw new AnjayException(result, "failed to restore Security object");
        }
    }

    public boolean isModified() {
        return this.anjaySecurityObjectIsModified();
    }
}

